'Print Preview Include by Gary Beene  ver 3.44     13 Jan 2013
'Modified by James Klutho to be used with My Little Grid August 2013
'This code is released to public domain. There are no restrictions on its use.

'Features:
'See the home page for details:  http://www.garybeene.com/sw/gbprintpreview.htm

'Steps to convert INCLUDE version of gbPrin
'1. Add Compile DLL and #Include statements
'2. Add VersionInfo content /update version # and date
'3. main SUB: add ALIAS and EXPORT

#COMPILE DLL "MLGPrint.dll"
'#INCLUDE "CWindow.inc
#INCLUDE "WIN32API.INC"

#RESOURCE BITMAP ppprint, "images\mlg_print\print.bmp"
#RESOURCE BITMAP ppyang, "images\mlg_print\yang.bmp"
#RESOURCE BITMAP ppfirst, "images\mlg_print\first.bmp"
#RESOURCE BITMAP ppforward, "images\mlg_print\forward.bmp"
#RESOURCE BITMAP ppback, "images\mlg_print\back.bmp"
#RESOURCE BITMAP pplast, "images\mlg_print\last.bmp"
#RESOURCE BITMAP ppzoom, "images\mlg_print\zoom.bmp"
#RESOURCE BITMAP ppabout, "images\mlg_print\about.bmp"
#RESOURCE BITMAP ppexit, "images\mlg_print\exit.bmp"
#RESOURCE BITMAP pptext, "images\mlg_print\text.bmp"

#RESOURCE VERSIONINFO
#RESOURCE FILEVERSION 1,0,0,0
#RESOURCE STRINGINFO "0409", "04B0"
#RESOURCE VERSION$ "FileVersion",       "1.00"
#RESOURCE VERSION$ "CompanyName",       "James Klutho"
#RESOURCE VERSION$ "FileDescription",   "MLG Print Preview"
#RESOURCE VERSION$ "ProductVersion",    "1.00"
#RESOURCE VERSION$ "OriginalFileName",  "MLGPrint.dll"
#RESOURCE VERSION$ "ProductName",       "MLGPrintPreview"
#RESOURCE VERSION$ "LegalCopyright",    "2013 James Klutho"
#RESOURCE VERSION$ "Comments",          "None"

'Print Preview Equates =====================================
ENUM Controls SINGULAR
   IDT_PrinterSelect      = 500
   IDT_PrintSettings
   IDT_PrintPrior
   IDT_PrintNext
   IDT_PrintAll
   IDT_PrintPage
   IDT_PrintRange
   IDT_PrintZoom
   IDT_PrintOrientation
   IDT_PrintShowMargins
   IDT_PrintHeader
   IDT_PrintFooter
   IDT_PrintBlankA
   IDT_PrintBlankB
   IDT_PrintBlankC
   IDT_PrintClose
   IDT_PrintFirst
   IDT_PrintLast
   IDT_PrintAbout



   IDC_PPToolbar
   IDC_PrintGraphicHidden
   IDC_PrintBackGround
   IDC_PrintGraphicVisible
   IDC_PrintPages
   IDC_PrintMinPage
   IDC_PrintMaxPage
   IDC_PrintRangeLabel
   IDC_PrintPageLabel
   IDC_PrintNumCopies

   IDC_PrintSettingsMT
   IDC_PrintSettingsML
   IDC_PrintSettingsMR
   IDC_PrintSettingsMB
   IDC_PrintSettingsMTL
   IDC_PrintSettingsMLL
   IDC_PrintSettingsMRL
   IDC_PrintSettingsMBL
   IDC_PrintSettingsOK
   IDC_PrintSettingsApply
   IDC_PrintSettingsCancel
   IDC_PrintSettingsOrientation
   IDC_PrintSettingsPortrait
   IDC_PrintSettingsLandscape
   IDC_PrintSettingsMargins
   IDC_PrintSettingsPaper
   IDC_PrintSettingsTray
   IDC_PrintSettingsVCenter
   IDC_PrintSettingsHCenter
   IDC_PrintSettingsGridlines
   IDC_PrintOpen
   IDC_PrintSaveAs
   IDC_PrintSettingsPrintDlg

   IDM_PrintZoomPage
   IDM_PrintZoomWidth
   IDM_PrintZoom25
   IDM_PrintZoom50
   IDM_PrintZoom75
   IDM_PrintZoom100
   IDM_PrintZoom200
   IDM_PrintZoom400

   IDM_PrintHome
   IDM_PrintEnd

   IDM_PrintCut
   IDM_PrintCopy
   IDM_PrintPaste
   IDM_PrintDelete
   IDM_PrintProperties
   IDM_PrintTest
   IDM_Help
END ENUM

'version
$PPVer = "1.00"

' orientation
%PPOrientation_Landscape  = 0
%PPOrientation_Portrait   = 1

' ZOOM Constants =  1 based index of selected item in combobix
%PPZoom_Page  =  1
%PPZoom_Width =  2
%PPZoom_25    =  3
%PPZoom_50    =  4
%PPZoom_75    =  5
%PPZoom_100   =  6
%PPZoom_200   =  7
%PPZoom_400   =  8

'--------MLG-----------------

$MLGPRINTFILE = "MLG_Temp_Print.tmp"
$MLGP = CHR$(254) '"|"
$MLGPRINTVERSION = "MLGPA"

%MLGN_PRINTPREVIEWMESSAGE  = %WM_USER + 370'*NEW 2.07   'from the DLL

TYPE MyGridData
   NMHeader AS NMHDR
   Param1 AS LONG
   Param2 AS LONG
   Param3 AS LONG
   Param4 AS LONG
END TYPE

TYPE MergeObject
       WhichObject AS LONG
       Offsetx AS LONG
       Offsety AS LONG
       CellVJust AS LONG
       CellFont AS LONG
       CellJust AS LONG
       CellStyle AS LONG
       TextCellColor AS LONG
       BkgGndCellColor AS LONG
       PrintStr AS ASCIIZ * 256
       DrawRect AS RECT
END TYPE

%FONT_NORMAL      = 0
%FONT_BOLD        = 1
%FONT_ITALIC      = 2
%FONT_UNDER       = 4
%FONT_STRIKE      = 8

%MLGSYSFONTNORMVERT = 5
%MLGSYSFONTBOLDVERT = 6

'Justification formats
%MLG_JUST_LEFT         = 0
%MLG_JUST_RIGHT        = 1
%MLG_JUST_CENTER       = 2
%MLG_JUST_WORDWRAP     = 3
'--------MLG END--------------


'PrintPreview Global Variables =================================================================
GLOBAL PPFontName, PPFontNameH,PPPrintArray(), PPText, PPImageHeader, PPImageFooter, PPPrinterName AS STRING
GLOBAL PPDeadZoneLeft, PPDeadZoneTop, PPDeadZoneRight, PPDeadZoneBottom AS SINGLE
GLOBAL PPMarginLeft, PPMarginRight, PPMarginTop, PPMarginBottom AS SINGLE
GLOBAL PPHeader, PPFooter, PPMaxWidth, PPScreenX, PPScreenY, PPPaperX, PPPaperY AS SINGLE
GLOBAL PPMaxPages, PPCurrentPage, PPLinesPerPage AS LONG, PPPrintTime AS STRING
GLOBAL PPScreenPPIx,  PPScreenPPIy, PPPrinterPPIx, PPPrinterPPIy, PPPrinterSelect AS LONG
GLOBAL PPShowFooter, PPShowHeader, PPFontPointsH, PPFontPoints, PPFontStyleH, PPFontStyle AS LONG, PPHeaderArg, PPFooterArg AS SINGLE
GLOBAL PPAutoClose, PPOrientation, PPShowMargins, PPZoom, PPWordWrap AS LONG
GLOBAL PPSmallImageX, PPSmallImageY, PPScrollSizeX, PPScrollSizeY, hPPcFont AS LONG
GLOBAL hParent, hPPFontText, hPPFontHeader, hPPDialog, hPPPageSetupDlg, hPPViewPort, hPopupPPZoom AS DWORD
GLOBAL PPhs,PPvs,PPwMax,PPhMax AS LONG, PPImageList, PPOldProc, hPPPopupContext  AS DWORD

GLOBAL PPHeaderTextL, PPHeaderTextC, PPHeaderTextR, PPFooterTextL, PPFooterTextC, PPFooterTextR AS STRING
GLOBAL PPSubHeaderText, PPZoomText() AS STRING
GLOBAL PPHeaderContWidth, PPHeaderContHeight, PPFooterContWidth, PPFooterContHeight AS SINGLE
GLOBAL PPImageHeaderW,PPImageHeaderH, PPImageFooterW, PPImageFooterH, PPUseDefaultHeaderText AS LONG
'--------------JEK Adds--------------------------------
GLOBAL gToolbarIcon() AS DWORD
GLOBAL gPrintAreaTop,gPrintAreaLeft,gPrintAreaBottom,gPrintAreaRight AS LONG
GLOBAL gPrintRepeatRowsTop,gPrintRepeatRowsLeft,gPrintRepeatRowsBottom,gPrintRepeatRowsRight AS LONG
GLOBAL gPrintRepeatColsTop,gPrintRepeatColsLeft,gPrintRepeatColsBottom,gPrintRepeatColsRight AS LONG
GLOBAL gMLGFonts() AS DWORD
GLOBAL gMLGFontStrings() AS STRING
GLOBAL gMLGsdata() AS STRING
GLOBAL gMLGUBoundx,gMLGUBoundy AS LONG
GLOBAL gMLGUBoundRowsx,gMLGUBoundRowsy AS LONG
GLOBAL gMLGUBoundColsx,gMLGUBoundColsy AS LONG
GLOBAL gNumberOfPages AS LONG
GLOBAL gPages() AS STRING
GLOBAL PPMaxLength AS SINGLE
GLOBAL gPPMT, gPPML, gPPMB, gPPMR AS SINGLE
GLOBAL PPShowRowColHeaders AS LONG
GLOBAL gGraphicDC,gPrinterDC AS DWORD
GLOBAL gTempFileVersion AS STRING
GLOBAL gMLGRowHeaderHeight AS SINGLE
GLOBAL gMLGColHeaderWidth AS SINGLE
GLOBAL gMLGRowRepeatHeight AS SINGLE
GLOBAL gMLGColRepeatWidth AS SINGLE
GLOBAL gMyObjects() AS MergeObject
GLOBAL gMyTime,gMyDate AS STRING
GLOBAL gPageOrder,gGridlines,NumMergeObjects AS LONG
GLOBAL gPPCopies,gPrintMin,gPrintMax,gPaper,gTray,gMarginsMM,gPrintVertCentering, gPrintHorzCentering AS LONG
GLOBAL gMyPapers,gMyTrays AS STRING

SUB gbPrintPreview ALIAS "gbPrintPreview" (BYVAL hWin AS DWORD, _     'handle to parent dialog
                   BYVAL MLGParent AS DWORD, _ 'MLG Parent
                   BYVAL MLG AS DWORD, _      'MLG control handle
                   BYVAL MLGCntlID AS DWORD, _'MLG control id
                   BYVAL PPFNH AS STRING, _   'font name (header/footer)
                   BYVAL PPFPH AS LONG, _     'font size (points) (header/footer)
                   BYVAL PPFSH AS LONG, _     'font style  0=normal 1=bold (header/footer)
                   BYVAL PPT AS STRING, _     'print file     ---------->text to display
                   BYVAL PPHT AS STRING, _    'MLG PrintDLL version expected
                   BYVAL PPFT AS STRING, _    'footer text (Left + $Tab + Center + $Tab + Right)
                   BYVAL PPRCH AS LONG, _     'Print centering
                   PPPN AS STRING, _          'printer name ("" = default)
                   BYVAL PPIH AS STRING, _    'header image file name, *.bmp
                   BYVAL PPIF AS STRING, _    'footer image file name, *.bmp
                   BYVAL PPHIW AS SINGLE, _   'Min Page
                   BYVAL PPHIH AS SINGLE, _   'Max Page
                   BYVAL PPFIW AS SINGLE, _   'Paper
                   BYVAL PPFIH AS SINGLE, _   'Tray
                   PPSH AS LONG, _            'display header 0=no 1=yes
                   PPSF AS LONG, _            'display footer 0=no 1=yes
                   BYVAL PPSM AS LONG, _      'showmargins  1=yes 0=no
                   BYVAL PPD AS LONG, _       'use default Page 1 of N header text 1=yes 0=no (-1 to flip Top-Right and Bottom-Right)
                   BYVAL PPHA AS SINGLE, _    'header size (inches)
                   BYVAL PPFA AS SINGLE, _    'footer size (inches)
                   PPML AS SINGLE, _          'left margin - inches
                   PPMR AS SINGLE, _          'right margin - inches
                   PPMT AS SINGLE, _          'top margin - inches
                   PPMB AS SINGLE, _          'bottom margin - inches
                   PPZ AS LONG, _             'zoom 1=fit_inside  2=fit_width  3=25% 4=50% 5=75% 6=100% 7=200% 8=400$ (-1 to Direct Print, -1minmax LONG format)
                   BYVAL PPWW AS LONG, _      'wordwrap  1=yes 0=no
                   BYVAL PPAC AS LONG, _      'autoclose  1=yes 0=no
                   PPO AS LONG) EXPORT        'orientation 1=portrait 0=landscape

  LOCAL result AS LONG

  IF PPRCH = 1 OR PPRCH = 3 THEN gPrintVertCentering = 1
  IF PPRCH = 2 OR PPRCH = 3 THEN gPrintHorzCentering = 1

 ' msgbox str$(PPRCH)

  gPPCopies = PPD '
  IF gPPCopies < 1 THEN gPPCopies = 1

  gMyTime = TIME$
  gMyDate = DATE$

   hParent = hWin

   'Not used by MLG
   PPFontName = "Arial"
   PPFontPoints = 12
   PPFontStyle = 0

   'Default header fonts  could change by reading the print file
   PPFontNameH = "Arial"
   PPFontPointsH = 10
   PPFontStyleH = 0

   PPText = PPT    'Not used by MLG
   PPShowRowColHeaders = 0  'this will change by reading the print file

   PPPrinterName = PPPN
 '  IF ISTRUE(ISFILE(PPIH)) THEN PPImageHeader = PPIH  'ignore if not valid file name
 '  IF ISTRUE(ISFILE(PPIF)) THEN PPImageFooter = PPIF  'ignore if not valid file name

   gPrintMin = PPHIW
   gPrintMax = PPHIH
   gPaper = PPFIW
   gTray = PPFIH

   'msgbox str$( gPrintMin) & str$(gPrintMax)

   PPShowHeader = PPSH
   PPShowFooter = PPSF
   PPShowMargins = PPSM

  ' PPUseDefaultHeaderText = PPD
   PPHeaderArg = 0' PPHA
   PPFooterArg = 0' PPFA

   'Change margin behavior from Gary Beene
   gPPML = PPML
   gPPMR = PPMR
   gPPMT = PPMT
   gPPMB = PPMB

   PPZoom = PPZ
   gMarginsMM = PPWW   'Millimeters in the margins
   PPOrientation = PPO
   PPAutoClose = PPAC

   '--------MLG-----------------
   IF ISTRUE(ISFILE($MLGPRINTFILE)) THEN
       result = MLG_ReadPrintFile($MLGPRINTFILE)
       IF result <> 0 THEN
          MSGBOX "Bad file format - abort printing
          EXIT SUB
       END IF
     ELSE
       EXIT SUB
   END IF
   '--------MLG END-----------------

   MLG_SendNotifyMessage MLGParent,MLG,MLGCntlID,%MLGN_PRINTPREVIEWMESSAGE,1,2,3,4

   DisplayPrintPreviewDialog
    'Don't send anything back to the sender

END SUB

'--------MLG-----------------

 'MyPaperWidth = GetPaperSize(PaperSize, 0)
 'MyPaperHeight = GetPaperSize(PaperSize, 1)

'%DMPAPER_LETTER    =  1      Letter    8.5   x 11    inches
'%DMPAPER_TABLOID   =  3      Tabloid   11    x 17    inches
'%DMPAPER_LEDGER    =  4      Ledger    17    x 11    inches
'%DMPAPER_LEGAL     =  5      Legal     8.5   x 14    inches
'%DMPAPER_STATEMENT =  6      Statement 5.5   x 8.5   inches
'%DMPAPER_EXECUTIVE =  7      Executive 7.25  x 10.5  inches
'%DMPAPER_A3        =  8      A3        297   x 420   mm
'%DMPAPER_A4        =  9      A4        210   x 297   mm
'%DMPAPER_A5        = 11      A5        148   x 210   mm
'%DMPAPER_B4        = 12      B4        250   x 354   mm
'%DMPAPER_B5        = 13      B5        182   x 257   mm
'%DMPAPER_FOLIO     = 14      Folio     8.5   x 13    inches
'%DMPAPER_QUARTO    = 15      Quarto    215   x 275   mm
'%DMPAPER_10X14     = 16      10x14     10    x 14    inches
'%DMPAPER_11X17     = 17      11x17     11    x 17    inches
'%DMPAPER_NOTE      = 18      Note      8.5   x 11    inches
'%DMPAPER_ENV_9     = 19      9 Envlp   3.875 x 8.875 inches
'%DMPAPER_ENV_10    = 20      10 Envlp  4.125 x 9.5   inches

FUNCTION MLG_GetPapersize (PaperSize AS LONG, RetWidth AS LONG) AS SINGLE

   LOCAL PrintPageWidth AS SINGLE
   LOCAL PrintPageHeight AS SINGLE

   SELECT CASE PaperSize
      CASE %DMPAPER_LETTER,2:
         PrintPageWidth = 8.5
         PrintPageHeight = 11
      CASE %DMPAPER_TABLOID:
         PrintPageWidth = 11
         PrintPageHeight = 17
      CASE %DMPAPER_LEDGER:
         PrintPageWidth = 17
         PrintPageHeight = 11
      CASE %DMPAPER_LEGAL:
         PrintPageWidth = 8.5
         PrintPageHeight = 14
      CASE %DMPAPER_STATEMENT:
         PrintPageWidth = 5.5
         PrintPageHeight = 8.5
      CASE %DMPAPER_EXECUTIVE:
         PrintPageWidth = 7.25
         PrintPageHeight = 10.5
      CASE %DMPAPER_A3:
         PrintPageWidth = 297 / 25.4
         PrintPageHeight = 420 / 25.4
      CASE %DMPAPER_A4,10:
         PrintPageWidth = 210 / 25.4
         PrintPageHeight = 297 / 25.4
      CASE %DMPAPER_A5:
         PrintPageWidth = 148 / 25.4
         PrintPageHeight = 210 / 25.4
      CASE %DMPAPER_B4:
         PrintPageWidth = 250 / 25.4
         PrintPageHeight = 354 / 25.4
      CASE %DMPAPER_B5:
         PrintPageWidth = 182 / 25.4
         PrintPageHeight = 257 / 25.4
      CASE %DMPAPER_FOLIO:
         PrintPageWidth = 8.5
         PrintPageHeight = 13
      CASE %DMPAPER_QUARTO:
         PrintPageWidth = 215 / 25.4
         PrintPageHeight = 275 / 25.4
      CASE %DMPAPER_10X14:
         PrintPageWidth = 10
         PrintPageHeight = 14
      CASE %DMPAPER_11X17:
         PrintPageWidth = 11
         PrintPageHeight = 17
      CASE %DMPAPER_NOTE:
         PrintPageWidth = 8.5
         PrintPageHeight = 11
      CASE %DMPAPER_ENV_9:
         PrintPageWidth = 3.875
         PrintPageHeight = 8.875
      CASE %DMPAPER_ENV_10:
         PrintPageWidth = 4.125
         PrintPageHeight = 9.5
      CASE ELSE
         PrintPageWidth = 8.5
         PrintPageHeight = 11
   END SELECT

   IF RetWidth = 0 THEN
      FUNCTION = PrintPageHeight
   ELSE
      FUNCTION = PrintPageWidth
   END IF

END FUNCTION

SUB MLG_mbox(hParent AS LONG, outstr AS STRING)
    LOCAL temp AS LONG
    LOCAL mystr AS ASCIIZ * 2000

    mystr = outstr
    temp = MessageBox(hParent, mystr, "About", %MB_OK)

END SUB

FUNCTION MLG_CreateFont ( BYVAL which AS LONG ) AS LONG
   'which is 0 for printer fonts and 1 for graphic fonts
   'GLOBAL gMLGFonts() AS DWORD
   'GLOBAL gMLGFontStrings() AS STRING
   '
   DIM zFontName AS ASCIIZ * 100
   DIM iPPIY AS INTEGER
   DIM iPPIX AS INTEGER
   DIM rNewFont AS LOGFONT
   LOCAL FontName,s AS STRING
   LOCAL FontStyle,FontSize,Degrees AS LONG
   LOCAL dcOutput,counter,fflag,temp4,temp5,temp6 AS LONG

   IF which = 0 THEN
       dcOutPut = gPrinterDC
       fflag = 0
     ELSE
       dcOutPut = gGraphicDC
       fflag = 1
   END IF

   iPPIX = GetDeviceCaps(dcOutput, %LOGPIXELSX)
   iPPIY = GetDeviceCaps(dcOutput, %LOGPIXELSY)

   FOR counter = 0 TO 15

       s = gMLGFontStrings(counter)
       s = UNWRAP$(s,$DQ,$DQ)

       FontName = PARSE$(s,$MLGP,3)
       FontSize = VAL(PARSE$(s,$MLGP,4))
       FontStyle = VAL(PARSE$(s,$MLGP,5))
       degrees  = VAL(PARSE$(s,$MLGP,8))
       zFontName = TRIM$(fontName)

       'Make the header font
       IF counter = 0 THEN
         FONT END hPPFontHeader
         FONT NEW PPFontNameH, PPFontPointsH, PPFontStyleH TO hPPFontHeader
       END IF

       '- These FontSize values passed as POINTS. I must
       '  convert them into logical pixels.
       '
       IF FontSize > 0 THEN
         rNewFont.lfHeight = -1 * (fontSize * iPPIY ) / 72
        ELSE
         rNewFont.lfHeight = Fontsize
       END IF

       rNewFont.lfWidth = 0
       rNewFont.lfEscapement = degrees '* 10
       rNewFont.lfOrientation = degrees '* 10

       IF ( fontStyle AND %FONT_BOLD ) = %FONT_BOLD THEN
          rNewFont.lfWeight = %FW_BOLD
       ELSE
          rNewFont.lfWeight = %FW_NORMAL
       END IF

       IF (fontStyle AND %FONT_ITALIC) = %FONT_ITALIC THEN
         rNewFont.lfItalic = 1
       ELSE
         rNewFont.lfItalic = 0
       END IF

       IF (fontStyle AND %FONT_STRIKE) = %FONT_STRIKE THEN
         rNewFont.lfStrikeOut = 1
       ELSE
         rNewFont.lfStrikeOut = 0
       END IF

       IF (fontStyle AND %FONT_UNDER) = %FONT_UNDER THEN
         rNewFont.lfUnderline = 1
       ELSE
         rNewFont.lfUnderline = 0
       END IF

       rNewFont.lfCharSet = %DEFAULT_CHARSET
       rNewFont.lfOutPrecision = %OUT_DEFAULT_PRECIS
       rNewFont.lfClipPrecision = %CLIP_DEFAULT_PRECIS
       rNewFont.lfQuality = %PROOF_QUALITY
       rNewFont.lfPitchAndFamily = %DEFAULT_PITCH + %FF_DONTCARE
       rNewFont.lfFaceName = TRIM$(zFontName) + CHR$(0)

       '- First Retrieve Original Font
       zFontName = ""
       IF gMLGFonts(counter,fflag)<> 0 THEN DeleteObject(gMLGFonts(counter,fflag))
       gMLGFonts(counter,fflag) = CreateFontIndirect(rNewFont)

   NEXT counter

END FUNCTION

'MLGSendNotifyMessage MLGParentHNDL,MLGHNDL,MLGCntlID,%MLGN_PRINTPREVIEWMESSAGE,Param1,Param2,Param3,Param4

FUNCTION MLG_SendNotifyMessage(BYVAL hDlg AS DWORD, BYVAL hCtrl AS DWORD, BYVAL CtrlID AS DWORD, BYVAL NCode AS LONG,BYVAL MyParam1 AS LONG, BYVAL MyParam2 AS LONG, BYVAL MyParam3 AS LONG,OPT BYVAL MyParam4 AS LONG) AS LONG
  LOCAL NMG AS MyGridData

  NMG.NMHeader.hwndFrom=hCtrl
  NMG.NMHeader.idFrom=CtrlID
  NMG.NMHeader.code=NCode
  NMG.Param1=MyParam1
  NMG.Param2=MyParam2
  NMG.Param3=MyParam3
  NMG.Param4=MyParam4

  FUNCTION= SendMessage(hDlg, %WM_NOTIFY,CtrlID,VARPTR(NMG))
END FUNCTION

FUNCTION MLG_CalcPages(op AS LONG) AS LONG
    'op = 0 use repeat rows and cols if available
    'op = 1 do not use repeat rows and cols
    'opCollate = 0 'side to side
    'opCollate = 1 'up and down

    LOCAL temp,temp1,temp2,rowcount,colcount,whichcol,whichrow,pagecount AS LONG
    LOCAL mystr AS STRING
    LOCAL mywidth,myheight,pagecumwidth,pagecumheight,colrepeatwidth,rowrepeatheight,rowheight,colwidth,tempw AS SINGLE
    LOCAL mycaption AS STRING
    LOCAL mycolwidths,myrowheights AS STRING

    'Maximum printable width and length  PPMaxWidth  PPMaxLength
    RESET gPages()
    REDIM gPages(999) AS STRING  'this is wasteful but easy.  Gary has max pages to 999
    pagecumwidth =0
    pagecumheight = 0

    '-----------------------------------------------------------------------------------------
    'First get the row, column and repeat row and column space requirements in inches

    'get the width of the repeating column in inches   '"HCOL | 3| 100| 50|C"
    IF gMLGUBoundColsx > 0 THEN
        colrepeatwidth = 0
        FOR colcount = gMLGUBoundx + 2 TO gMLGUBoundx + 1 + gMLGUBoundColsx
           colrepeatwidth =  colrepeatwidth + (VAL(PARSE$(gMLGsdata(0,colcount),$MLGP,3)))/PPScreenPPIx
           'msgbox str$(colrepeatwidth) + PARSE$(gMLGsdata(0,colcount),$MLGP,3)+ "  :  " + gMLGsdata(0,colcount )'+ "  :  " + str$(PPScreenPPIx)
        NEXT colcount
      ELSE
        colrepeatwidth = 0
    END IF

    'get the height of the repeating rows in inches    '"HROW | 1| 50| 32|1"
    IF gMLGUBoundRowsy > 0 THEN
        FOR rowcount = gMLGUBoundy + 2 TO gMLGUBoundy + 1 + gMLGUBoundRowsy
           'msgbox str$(gMLGUBoundy) + str$(rowcount)
            rowrepeatheight =  rowrepeatheight + (VAL(PARSE$(gMLGsdata(rowcount,0),$MLGP,3)))/PPScreenPPIy
           'msgbox str$(rowrepeatheight) + PARSE$(gMLGsdata(rowcount,0),$MLGP,3)+ "  :  " + gMLGsdata(rowcount,0)'+ "  :  " + str$(PPScreenPPIx)
        NEXT rowcount
      ELSE
        rowrepeatheight = 0
    END IF


   rowheight = 0
   colwidth  = 0
   IF PPShowRowColHeaders <> 0 THEN
       IF PPShowRowColHeaders = 2 OR PPShowRowColHeaders = 3 THEN rowheight = (VAL(PARSE$(gMLGsdata(0,1),$MLGP,2)))/PPScreenPPIy
       IF PPShowRowColHeaders = 1 OR PPShowRowColHeaders = 3 THEN colwidth =  (VAL(PARSE$(gMLGsdata(1,0),$MLGP,2)))/PPScreenPPIx
   END IF
   gMLGRowHeaderHeight = rowHeight
   gMLGColHeaderWidth = colwidth

   gMLGRowRepeatHeight = rowrepeatheight
   gMLGColRepeatWidth = colrepeatwidth

  '-----------------------------------------------------------------------------
   'Now figure the Column Page limits
   'Load in the mycolwidths string variable
   tempw=colwidth + colrepeatwidth
   mycolwidths = "1,"
   FOR colcount = 1 TO gMLGUBoundx
      tempw = tempw +  (VAL(PARSE$(gMLGsdata(0,colcount),$MLGP,3)))/PPScreenPPIx
      IF tempw > PPMaxWidth THEN
          'the previous pagecumwidth was the last to be able to fit on the page width
           mycolwidths =  mycolwidths  & STR$(colcount-1) & $MLGP  &  STR$(colcount)& ", "
          'reset
          tempw=colwidth + colrepeatwidth
          DECR colcount
        ELSE
          'not sure what this will be used for
          pagecumwidth = pagecumwidth + tempw
      END IF
   NEXT colcount
   mycolwidths =  mycolwidths  & STR$(colcount-1) 'close up the last page
   pagecumwidth = 0

  ' MSGBOX mycolwidths

   '-----------------------------------------------------------------------------
   'Now figure the Row Page limits
   'Load in the myrowheights string variable
   tempw=rowheight + rowrepeatheight
   myrowheights = "1,"
   FOR rowcount = 1 TO gMLGUBoundy
      tempw = tempw +  (VAL(PARSE$(gMLGsdata(rowcount,0),$MLGP,3)))/PPScreenPPIy
      IF tempw > PPMaxLength THEN
          'the previous pagecumwidth was the last to be able to fit on the page width
           myrowheights =  myrowheights  & STR$(rowcount-1) & $MLGP  &  STR$(rowcount)& ", "
          'reset
          tempw=rowheight + rowrepeatheight
          DECR rowcount
        ELSE
          'not sure what this will be used for
          pagecumheight = pagecumheight
      END IF
   NEXT rowcount
   myrowheights =  myrowheights  & STR$(rowcount-1) 'close up the last page
   pagecumheight = 0

 '  MSGBOX myrowheights

   IF rowheight > 0 THEN temp1 = 1 ELSE temp1 = 0
   IF colwidth > 0 THEN temp2 = 1 ELSE temp2 = 0

   temp = PARSECOUNT(myrowheights,$MLGP) * PARSECOUNT(mycolwidths,$MLGP)

   gPages(0) = STR$(temp)  + "," +  STR$(temp1) + "," + STR$(temp2)  + "," + STR$(gMLGUBoundRowsy) + "," + STR$(gMLGUBoundColsx)
   PPMaxPages = temp
 '  MSGBOX gPages(0)
  '-----------------------------------------------------------------------------
   'Now figure the pages and put in the gPages() array
   temp1 = PARSECOUNT(myrowheights,$MLGP)
   temp2 = PARSECOUNT(mycolwidths,$MLGP)
   IF gPageOrder = 0 THEN 'pages are across then down

        pagecount = 1
        FOR rowcount = 1 TO temp1
            FOR colcount = 1 TO temp2
              gPages(pagecount) = PARSE$(myrowheights,$MLGP,rowcount) + $MLGP + PARSE$(mycolwidths,$MLGP,colcount)
              INCR pagecount
              IF pagecount > 999 THEN EXIT FUNCTION 'do not overrun gPages()
            NEXT colcount
        NEXT rowcount

      ELSE   'pages are down and then across

        pagecount = 1
        FOR colcount = 1 TO temp2
            FOR rowcount = 1 TO temp1
              gPages(pagecount) = PARSE$(myrowheights,$MLGP,rowcount) + $MLGP + PARSE$(mycolwidths,$MLGP,colcount)
              INCR pagecount
              IF pagecount > 999 THEN EXIT FUNCTION 'do not overrun gPages()
            NEXT rowcount
        NEXT colcount

   END IF

   PPCurrentPage = 1
   CONTROL SET TEXT hPPDialog, %IDC_PrintMinPage, STR$(PPCurrentPage)
   CONTROL SET TEXT hPPDialog, %IDC_PrintMaxPage, STR$(PPMaxPages)
   CONTROL SET TEXT hPPDialog, %IDC_PrintNumCopies , STR$(gPPCopies)

   ' msgbox gPages(0)
   ' MSGBOX gPages(1)

END FUNCTION

FUNCTION MLG_ReadPrintFile(theFile AS STRING) AS LONG
  LOCAL s,keyword,sdata,NameFace,mystr AS STRING
  LOCAL temp,temp1,temp2,temp3,temp4,temp5,temp6,temp7 AS LONG
  LOCAL rhrowcount, chcolcount, rowcount, colcount ,rrowcount,rcolcount ,rrowcount2,rcolcount2,mergeojectcount AS LONG
  REDIM gMLGFonts(15,1) AS DWORD
  REDIM gMLGFontStrings(15) AS STRING
  REDIM gMyObjects(16) AS MergeObject
  LOCAL mypoints AS SINGLE
  LOCAL tempdt,MyTextColor,MyBkgndColor,MyFont,foTempBrush,DTVC,WhichObject AS LONG
  LOCAL mycell AS STRING

   chcolcount = 0 'column header column counter
   rhrowcount = 0 'row header row counter
   rowcount = 1 'row of the cell - start on the first row
   colcount = 0 'col of the cell
   rrowcount = 1 'repeat row count RRPT  - start on the first row
   rcolcount = 0 'repeat col count RRPT
   rrowcount2 = 0 'repeat row count CRPT
   rcolcount2 = 0 'repeat col count CRPT
   mergeojectcount = 0

  OPEN TheFile FOR INPUT AS #1
  WHILE ISFALSE EOF(1)  ' check if at end of file
    LINE INPUT #1, s
    s= UNWRAP$(s,$DQ,$DQ)
    keyword = TRIM$(PARSE$(s,$MLGP,1))
   ' keyword = UNWRAP$(keyword,$DQ,$DQ)

    SELECT CASE keyword

       CASE "VRSN" 'Temp Print File Version
          gTempFileVersion=TRIM$(PARSE$(s,$MLGP,2))
          gTempFileVersion = UNWRAP$(gTempFileVersion,$DQ,$DQ)

          IF $MLGPRINTVERSION <> gTempFileVersion THEN 'bail - file format change
             FUNCTION = 1
             CLOSE #1
             EXIT FUNCTION
          END IF

       CASE "AREA" 'Print Area
           '"AREA | 1| 1| 5| 4"
             gPrintAreaTop = VAL(PARSE$(s,$MLGP,2))
             gPrintAreaLeft = VAL(PARSE$(s,$MLGP,3))
             gPrintAreaBottom = VAL(PARSE$(s,$MLGP,4))
             gPrintAreaRight = VAL(PARSE$(s,$MLGP,5))

             gMLGUBoundx = (gPrintAreaRight - gPrintAreaLeft) + 1
             gMLGUBoundy = (gPrintAreaBottom - gPrintAreaTop) + 1

             ' Should not happen
             IF gMLGUBoundx < 1 THEN gMLGUBoundx = 1
             IF gMLGUBoundy < 1 THEN gMLGUBoundy = 1

             REDIM gMLGsdata(gMLGUBoundy + 7 ,gMLGUBoundx + 7) AS STRING  ' give a leeway on dimensioning and room for repeat rows and columns
             rrowcount = gMLGUBoundy + 2 'repeat row count up to 4 allowed   1 blank element between repeat and cell data
             rcolcount = 0  'repeat col count up to 4 allowed   1 blank element behind repeat and cell data
             rrowcount2 = 1 'repeat row count up to 4 allowed   1 blank element behind repeat and cell data
             rcolcount2 = gMLGUBoundx + 2 'repeat col count up to 4 allowed   1 blank element between repeat and cell data
       CASE "RROW"  'Repeat Rows
            ' "RROW | 1| 3| 1| 6"

             gPrintRepeatRowsTop = VAL(PARSE$(s,$MLGP,2))
             gPrintRepeatRowsLeft = VAL(PARSE$(s,$MLGP,3))
             gPrintRepeatRowsBottom = VAL(PARSE$(s,$MLGP,4))
             gPrintRepeatRowsRight = VAL(PARSE$(s,$MLGP,5))

             gMLGUBoundRowsx = (gPrintRepeatRowsRight - gPrintRepeatRowsLeft) + 1
             gMLGUBoundRowsy = (gPrintRepeatRowsBottom - gPrintRepeatRowsTop) + 1

             ' Should not happen
             IF gMLGUBoundRowsx < 1 THEN gMLGUBoundRowsx = 1
             IF gMLGUBoundRowsy < 1 THEN gMLGUBoundRowsy = 1

       CASE "RCOL" 'Repeat Columns
            ' "RCOL | 3| 1| 7| 1"
             gPrintRepeatColsTop = VAL(PARSE$(s,$MLGP,2))
             gPrintRepeatColsLeft = VAL(PARSE$(s,$MLGP,3))
             gPrintRepeatColsBottom = VAL(PARSE$(s,$MLGP,4))
             gPrintRepeatColsRight = VAL(PARSE$(s,$MLGP,5))

             gMLGUBoundColsx = (gPrintRepeatColsRight - gPrintRepeatColsLeft) + 1
             gMLGUBoundColsy = (gPrintRepeatColsBottom - gPrintRepeatColsTop) + 1

             ' Should not happen
             IF gMLGUBoundColsx < 1 THEN gMLGUBoundColsx = 1
             IF gMLGUBoundColsy < 1 THEN gMLGUBoundColsy = 1

       CASE "HTXT
              mystr =PARSE$(s,$MLGP,2)
            '  mystr = UNWRAP$(mystr,$DQ,$DQ)
              PPHeaderArg = 0

              IF LEN(TRIM$(mystr)) > 0 THEN  PPHeaderArg = 0.3
              PPHeaderTextL = PARSE$(mystr,$TAB,1)
              PPHeaderTextC = PARSE$(mystr,$TAB,2)
              PPHeaderTextR = PARSE$(mystr,$TAB,3)

              mystr =PARSE$(s,$MLGP,4)
              mystr = UNWRAP$(mystr,$DQ,$DQ)
              IF LEN(TRIM$(mystr)) > 0 THEN
               PPFontNameH =  PARSE$(mystr,$TAB,1)
               PPFontPointsH = VAL(PARSE$(mystr,$TAB,2))
               PPFontStyleH =  VAL(PARSE$(mystr,$TAB,3))
              END IF

              mystr =PARSE$(s,$MLGP,3)
              IF LEN(TRIM$(mystr)) > 0 THEN
               PPHeaderArg  = VAL(mystr)
              END IF

       CASE "FTXT"
             mystr =PARSE$(s,$MLGP,2)
            ' msgbox mystr
             PPFooterArg = 0
            ' mystr = UNWRAP$(mystr,$DQ,$DQ)
             IF LEN(TRIM$(mystr)) > 0 THEN
            '   if PPShowRowColHeaders = 2 then
            '        PPShowRowColHeaders = 3
                    PPFooterArg = 0.3
             '    else
              '      PPShowRowColHeaders =1
               '     PPFooterArg = 0.3
               'end if
             END IF
             PPFooterTextL = PARSE$(mystr,$TAB,1)
             PPFooterTextC = PARSE$(mystr,$TAB,2)
             PPFooterTextR = PARSE$(mystr,$TAB,3)

             mystr =PARSE$(s,$MLGP,4)
             IF LEN(TRIM$(mystr)) > 0 THEN
               PPFontNameH =  PARSE$(mystr,$TAB,1)
               PPFontPointsH = VAL(PARSE$(mystr,$TAB,2))
               PPFontStyleH =  VAL(PARSE$(mystr,$TAB,3))
             END IF


            mystr =PARSE$(s,$MLGP,3)
            IF LEN(TRIM$(mystr)) > 0 THEN
               PPFooterArg  = VAL(mystr)
            END IF

       CASE "ORNT"
             PPOrientation = VAL(PARSE$(s,$MLGP,2))
             gPageOrder = VAL(PARSE$(s,$MLGP,3))
             gGridlines = VAL(PARSE$(s,$MLGP,4))
             PPShowRowColHeaders = VAL(PARSE$(s,$MLGP,5))

       CASE "MRGN"
             gPPMT = VAL(PARSE$(s,$MLGP,2))
             gPPML = VAL(PARSE$(s,$MLGP,3))
             gPPMB = VAL(PARSE$(s,$MLGP,4))
             gPPMR = VAL(PARSE$(s,$MLGP,5))

       CASE "FONT"
            '"FONT | 6|Tahoma|-13|700|0|0|900"
             temp1 = VAL(PARSE$(s,$MLGP,2))
             NameFace = PARSE$(s,$MLGP,3)
             mypoints = ABS(VAL(PARSE$(s,$MLGP,4)))
             temp4 = VAL(PARSE$(s,$MLGP,5))
             temp5 = VAL(PARSE$(s,$MLGP,6))
             temp6 = VAL(PARSE$(s,$MLGP,7))
             temp7 = VAL(PARSE$(s,$MLGP,8))
             'FONT NEW NameFace ,mypoints, temp4, temp5, temp6, temp7 TO gMLGFonts(temp1,0)
             gMLGFontStrings(temp1)= s

       CASE "CELL"
            '      row col top left btm  rgt just  tclr   bclr    border   font   sdata
           ' "CELL | 1| 1| 119| 52| 151| 118| 0   |   0| 16777215| 0     |     0|1938.00"
           IF colcount < gMLGUBoundx THEN INCR colcount ELSE INCR rowcount : colcount = 1

           IF (rowcount <= gMLGUBoundy) AND (colcount <= gMLGUBoundx) THEN

             gMLGsdata(rowcount,colcount) = MID$(s,8)
           END IF

          ' msgbox str$(rowcount) + str$(colcount) + ":  " +  gMLGsdata(rowcount,colcount)

       CASE "HROW" 'Header Rows
            INCR rhrowcount
           '"HROW | 4| 50| 32|4"
            IF (rhrowcount <= gMLGUBoundy) THEN gMLGsdata(rhrowcount,0) = PARSE$(s,$MLGP,2) + $MLGP +  PARSE$(s,$MLGP,3) + $MLGP +  PARSE$(s,$MLGP,4) + $MLGP +  PARSE$(s,$MLGP,5)
            ' MSGBOX   "Row Data  " + gMLGsdata(rhrowcount,0)
            ' MSGBOX "Row Header   " +STR$(rhrowcount)
       CASE "HCOL" 'Header Columns
            INCR chcolcount
           '"HCOL | 3| 100| 50|C"
            IF (chcolcount <= gMLGUBoundx) THEN gMLGsdata(0,chcolcount) = PARSE$(s,$MLGP,2) + $MLGP +  PARSE$(s,$MLGP,3) + $MLGP +  PARSE$(s,$MLGP,4) + $MLGP +  PARSE$(s,$MLGP,5)
          '  MSGBOX   "Col Data  " + gMLGsdata(0,chcolcount)
           ' MSGBOX "Col Header   " +STR$(chcolcount)
       CASE "RRPT"
            '"RRPT | 1| 3| 119| 52| 151| 98| 0| 0| 15658671| 0| 0|1040.00"
           IF rcolcount < gMLGUBoundx  THEN INCR rcolcount ELSE INCR rrowcount : rcolcount = 1

           IF (rrowcount <= gMLGUBoundy + 6) AND (rcolcount <= gMLGUBoundx + 6) THEN
             'msgbox str$(rrowcount)+ str$(rcolcount) + " ; " + gMLGsdata(rrowcount,rcolcount)
             gMLGsdata(rrowcount,rcolcount) = MID$(s,8)
             gMLGsdata(rrowcount,0) = PARSE$(s,$MLGP,14) + $MLGP +  PARSE$(s,$MLGP,15) + $MLGP +  PARSE$(s,$MLGP,16) + $MLGP +  PARSE$(s,$MLGP,17)
           END IF

          ' MSGBOX   "Repeat Row Data  " + str$(rrowcount) + ":" + gMLGsdata(rrowcount,rcolcount)

       CASE "CRPT"
           '"CRPT | 1| 3| 119| 52| 151| 98| 0| 0| 15658671| 0| 0|1040.00"

           IF (rrowcount2 <= gMLGUBoundy + 6) AND (rcolcount2 <= gMLGUBoundx + 6) THEN
             gMLGsdata(rrowcount2,rcolcount2) = MID$(s,8)
             gMLGsdata(0,rcolcount2) = PARSE$(s,$MLGP,14) + $MLGP +  PARSE$(s,$MLGP,15) + $MLGP +  PARSE$(s,$MLGP,16) + $MLGP +  PARSE$(s,$MLGP,17)
           END IF

           'MSGBOX   "Repeat Col Data  " + STR$(rrowcount2)+ STR$(rcolcount2) + ":" + gMLGsdata(0,rcolcount2)

           IF rcolcount2 < gMLGUBoundx + gMLGUBoundColsx + 1 THEN INCR rcolcount2 ELSE INCR rrowcount2 : rcolcount2 = gMLGUBoundx + 2

       CASE "OBJT"
         'myrow = LOWRD(MyObjects(temp).ObjectName)
         'mycol = HIWRD(MyObjects(temp).ObjectName)
      '    s= "OBJT "  + $MLGP + STR$(tempdt OR @v.RowCellVJust)+ $MLGP + STR$(temp)+ $MLGP + STR$(DrawRect.nTop)+ $MLGP + STR$(DrawRect.nLeft)+ $MLGP + STR$(DrawRect.nBottom)+ $MLGP + STR$(DrawRect.nRight)+ $MLGP
      ' s= s + STR$(CellJust)+ $MLGP + STR$(@v.TCellColor(TextCellColor))+ $MLGP + STR$(@v.BCellColor(BkgGndCellColor))+ $MLGP + STR$(xoffset)+","+STR$(yoffset) + $MLGP + STR$(CellFont)+ $MLGP + printstr
      ' MLG_PrintFile(s)

      '  TYPE MergeObject
      '     WhichObject
      '     Offsetx AS LONG
      '     Offsety AS LONG
      '     CellVJust as long
      '     CellFont as long
      '     CellJust as long
      '     CellStyle as long
      '     TextCellColor as long
      '     BkgGndCellColor as long
      '     PrintStr as asciiz * 256
      '     DrawRect AS RECT
      '  END TYPE

      'printing clipping
      '  MyRectRgn= CreateRectRgn( @v.PageDisplayDrawRect.nLeft, @v.PageDisplayDrawRect.nTop, @v.PageDisplayDrawRect.nRight, @v.PageDisplayDrawRect.nBottom)
      '  SelectClipRgn MyDC, MyRectRgn
          'put code here
      ' GetClientRect(hWnd,wRect)
      ' MyRectRgn2=CreateRectRgnIndirect(wRect)
      ' SelectClipRgn MyDC,MyRectRgn2
      '  '
      ' DeleteObject(MyRectRgn)
      ' DeleteObject(MyRectRgn2)




           mycell=s
           WhichObject = VAL(PARSE$(mycell,$MLGP,3))
           IF WhichObject > 0 AND WhichObject < 17 THEN
               gMyObjects(WhichObject).WhichObject = WhichObject
               tempdt  = VAL(PARSE$(mycell,$MLGP,2))
               'test for DT_VCENTER for row headers
               IF ( tempdt AND %DT_VCENTER ) = %DT_VCENTER THEN DTVC = %DT_VCENTER ELSE DTVC = 0
               gMyObjects(WhichObject).CellVJust = DTVC
               gMyObjects(WhichObject).CellStyle = TempDT
               gMyObjects(WhichObject).DrawRect.nTop = VAL(PARSE$(mycell,$MLGP,4))
               gMyObjects(WhichObject).DrawRect.nLeft = VAL(PARSE$(mycell,$MLGP,5))
               gMyObjects(WhichObject).DrawRect.nBottom = VAL(PARSE$(mycell,$MLGP,6))
               gMyObjects(WhichObject).DrawRect.nRight  = VAL(PARSE$(mycell,$MLGP,7))
               gMyObjects(WhichObject).CellJust = VAL(PARSE$(mycell,$MLGP,8))
               gMyObjects(WhichObject).TextCellColor  = VAL(PARSE$(mycell,$MLGP,9))
               gMyObjects(WhichObject).BkgGndCellColor =  VAL(PARSE$(mycell,$MLGP,10))
               gMyObjects(WhichObject).OffSetx = VAL(PARSE$(PARSE$(mycell,$MLGP,11),1))
               gMyObjects(WhichObject).Offsety = VAL(PARSE$(PARSE$(mycell,$MLGP,11),2))
               gMyObjects(WhichObject).CellFont = VAL(PARSE$(mycell,$MLGP,12))
               gMyObjects(WhichObject).PrintStr  = PARSE$(mycell,$MLGP,13)
           END IF

           IF WhichObject = 1 THEN
          '    msgbox str$(gMyObjects(1).OffSetx) + STR$(gMyObjects(1).OffSety) + ";  " + trim$(gMyObjects(1).Printstr) + ":  " + STR$(gMyObjects(1).OffSety)
           END IF

    END SELECT
  WEND
  CLOSE #1
END FUNCTION

FUNCTION MLG_DrawTextVert(MyhDC AS DWORD,str AS STRING,whichfont AS LONG,rc AS RECT,just AS LONG,SorP AS LONG,xScale AS SINGLE,YScale AS SINGLE) AS LONG
'SorP  0 = Screen or else printer

LOCAL Xpos AS LONG
LOCAL Ypos AS LONG
LOCAL slen AS LONG
LOCAL sdc,hdc AS LONG
LOCAL myfont AS DWORD

LOCAL Sptr AS STRING POINTER
LOCAL mysize AS SIZEL
LOCAL result AS LONG
LOCAL Screen AS LONG

      Sptr = STRPTR(str)
      slen = LEN(str)

       IF SorP = 1 THEN
         hDC = MyhDC
        ELSE
         hDC = MyhDC
       END IF

        SDC = SaveDC(HDC)
        IntersectClipRect(HDC, RC.NLEFT, RC.NTOP, RC.NRIGHT, RC.NBOTTOM)
        IF whichfont = %MLGSYSFONTNORMVERT THEN
            myfont = gMLGFonts(%MLGSYSFONTNORMVERT,SorP)    'test for print preview only
          ELSE
            myfont = gMLGFonts(%MLGSYSFONTBOLDVERT,SorP)
        END IF



        result=GetTextExtentPoint32(hDC,BYVAL STRPTR(str),LEN(str),mysize) 'mysize.cy
        ' myfont = gMLGFonts(1,1)
        SelectObject hDC,myfont
        'mlgdebug str$(just)

       ' %MLG_JUST_LEFT         = 0
       ' %MLG_JUST_RIGHT        = 1
       ' %MLG_JUST_CENTER       = 2
       ' %MLG_JUST_WORDWRAP     = 3


        IF just = %MLG_JUST_LEFT THEN 'Left
              Xpos = (Rc.nLeft) + 0  '(mysize.cy) + 2
              Ypos = Rc.nBottom - (2 * yScale)
            ELSEIF just = %MLG_JUST_RIGHT THEN 'Right
              Xpos = (Rc.nRight)-(mysize.cy) - (2 * xScale)
              Ypos = Rc.nBottom - (2 * yScale)
            ELSEIF %MLG_JUST_CENTER THEN 'Center
              Xpos = ((Rc.nLeft + Rc.nRight)\2) - ((mysize.cy)\2) + (2 * xScale)
              Ypos = Rc.nBottom - (2 * yScale)
            ELSE 'revert to left
              Xpos = (Rc.nLeft) + 0  '(mysize.cy) + 2
              Ypos = Rc.nBottom - (2 * yScale)
        END IF

        TextOut(HDC, Xpos, Ypos, BYVAL Sptr, slen)

        RestoreDC(HDC, SDC)

END FUNCTION

FUNCTION MLG_SelectAndOpenFile(FileName AS STRING) AS STRING
    LOCAL startfolder$, filter$, startfile$, defaultext$, flags&, filevar$, countvar&
    filter$ = "MLG Print File (*.mlg)" + $NUL + "*.mlg" + $NUL
    startfolder$ = IIF$(ISFILE(FileName), FileName, EXE.PATH$)     'initial folder to be displayed
    startfile$ = (FileName)       'name to be used as initial selection
    flags& = %OFN_EXPLORER OR %OFN_FILEMUSTEXIST OR %OFN_HIDEREADONLY
    DISPLAY OPENFILE hPPDialog, 100, 100, "", startfolder$, filter$, startfile$, defaultext$, flags& TO filevar$, countvar&
    IF LEN(filevar$) THEN
      FileName = filevar$
      FUNCTION = FileName
    END IF
END FUNCTION

FUNCTION MLG_SaveAs(FileName AS STRING) AS STRING
    LOCAL startfolder$, filter$, startfile$, defaultext$, flags&, filevar$, countvar&, temp$
    filter$ = "MLG Print File (*.mlg)" + $NUL + "*.mlg" + $NUL
    startfolder$ = IIF$(ISFILE(FileName), FileName, EXE.PATH$)     'initial folder to be displayed
    startfile$ = (FileName)       'name to be used as initial selection
    flags& = %OFN_EXPLORER OR %OFN_PATHMUSTEXIST OR %OFN_OVERWRITEPROMPT
    defaultext$ = "mlg"
    DISPLAY SAVEFILE hPPDialog, 100, 100, "Save Output to File", startfolder$, filter$, startfile$, defaultext$, flags& TO filevar$, countvar&
    IF LEN(filevar$) THEN
       FileName = filevar$
       FILECOPY $MLGPRINTFILE, Filename
      FUNCTION = FileName
    END IF
END FUNCTION

FUNCTION MLG_MakeBitmapMask(hSrcDC AS LONG,lWidth AS LONG, lHeight AS LONG,TransColor AS LONG) AS LONG
    LOCAL MonoDC,MonoBitmap AS LONG
    LOCAL x,y AS LONG

    'This is a 1 bit mask used by PlgBlt
    IF TransColor < 0 THEN TransColor = GetPixel(hSrcDC, 0, 0)

    MonoDC = CreateCompatibleDC(hSrcDC)
    MonoBitmap = CreateBitmap(lWidth, lHeight, 1, 1, BYVAL 0&)
    IF SelectObject(MonoDC, MonoBitmap) = 0 THEN EXIT FUNCTION

    FOR x = 0 TO lWidth -1
      FOR y = 0 TO lHeight -1
         IF GetPixel(hSrcDC, x, y) = TransColor THEN
              SetPixel(MonoDC, x, y,%BLACK)
           ELSE
              SetPixel(MonoDC, x, y,%WHITE)
         END IF
      NEXT y
    NEXT x

    DeleteDC MonoDC
    FUNCTION = MonoBitmap

END FUNCTION


'--------MLG END-----------------


SUB DisplayPrintPreviewDialog()

  ' IF PPHT <> $MLGPRINTVERSION THEN
  '    MSGBOX "Incompatible Print DLL Version"
  '    EXIT SUB
  ' END IF

   DIALOG NEW PIXELS, hParent, "Print Preview", 100, 100, 680, 500, %WS_OVERLAPPEDWINDOW OR %WS_CLIPCHILDREN TO hPPDialog
   'DIALOG SET ICON hPPDialog, "ppprintall"
    DIALOG SET COLOR hPPDialog, %BLACK, %RGB_LIGHTGRAY

   DIALOG NEW PIXELS, hPPDialog, "", 0, 60, 50, 50, %DS_CONTROL OR %WS_CHILD OR %WS_CLIPCHILDREN, 0 TO hPPViewPort

   DIALOG SET COLOR hPPViewPort, %BLACK, %RGB_LIGHTGRAY

   CONTROL ADD GRAPHIC, hPPViewPort, %IDC_PrintGraphicVisible, "", 0,0,50,50    ', %WS_Border Or %WS_TabStop
   GRAPHIC ATTACH hPPViewPort, %IDC_PrintGraphicVisible

   CONTROL ADD LABEL, hPPDialog, %IDC_PrintPageLabel, "1", 164,3,25,20, %WS_BORDER OR %SS_CENTER OR %SS_CENTERIMAGE OR %SS_NOTIFY

   CONTROL ADD TEXTBOX, hPPDialog, %IDC_PrintMinPage, "1", 299,3,26,20
   CONTROL ADD TEXTBOX, hPPDialog, %IDC_PrintMaxPage, "1", 333,3,29,20

   CONTROL ADD LABEL, hPPDialog, %IDC_PrintNumCopies, "1", 370,3,25,20, %WS_BORDER OR %SS_CENTER OR %SS_CENTERIMAGE OR %SS_NOTIFY

    ' GOTO bail
   IF PPZoom > 0 THEN CreateToolbar        'not create on Direct Print

   PPCurrentPage = 1 : PPPrintTime = DATE$ + " " + TIME$
   PPwMax = 500 : PPhMax = 500 : PPhs=5 : PPvs=5

   'get Header image dimensions
 '  IF LEN(PPImageHeader) THEN
 '     OPEN PPImageHeader FOR BINARY AS #1
 '     GET #1, 19, PPImageHeaderW
 '     GET #1, 23, PPImageHeaderH
 '     CLOSE #1
 '  END IF

   'get Headder image dimensions
 '  IF LEN(PPImageFooter) THEN
 '     OPEN PPImageFooter FOR BINARY AS #1
 '     GET #1, 19, PPImageFooterW
 '     GET #1, 23, PPImageFooterH
 '     CLOSE #1
 '  END IF

   'attach to specified printer
   IF LEN(PPPrinterName) THEN
      'name provided
      TRY
         XPRINT ATTACH PPPrinterName

      CATCH
         TRY
            XPRINT ATTACH DEFAULT
         CATCH
            MSGBOX "Printers not available!", %MB_OK + %MB_ICONEXCLAMATION + %MB_TASKMODAL, "Attaching to Printer"
            DIALOG END hPPViewPort
            DIALOG END hPPDialog
         END TRY
      END TRY
   ELSE
      'user requested default printer
      TRY
         XPRINT ATTACH DEFAULT
      CATCH
            MSGBOX "Printer not available!", %MB_OK + %MB_ICONEXCLAMATION + %MB_TASKMODAL, "Attaching to Printer"
            DIALOG END hPPViewPort
            DIALOG END hPPDialog
      END TRY
   END IF
   PPPrinterName = XPRINT$

   XPRINT SET PAPER gPaper
   XPRINT SET TRAY gTray
   IF PPOrientation = 1 THEN XPRINT SET ORIENTATION 1 ELSE XPRINT SET ORIENTATION 2
  '
   'initialize properties and display content to be printed
  ' FONT NEW PPFontName, PPFontPoints, PPFontStyle TO hPPFontText
  ' FONT NEW PPFontNameH, PPFontPointsH, PPFontStyleH TO hPPFontHeader

   SetPrintPreviewProperties

   CreateHiddenGraphicControl   'create graphic controls according to orientation 1=portrait 0=landscape
   CreatePrintContent           'format all output text, place in PPPrintArray()
   PrintToHiddenGraphic         'display PPCurrentPage on the full size hidden graphic control
   IF PPZoom < 0 THEN    'alternate use of arguments to allow printing specific pages without dialog
       ' PPZoom = -1 * (1000000 +  MinPage * 1000 + MaxPage)  ' -100n00n
       ' zoom 1=fit_inside  2=fit_width  3=25% 4=50% 5=75% 6=100% 7=200% 8=400$ (-1 to Direct Print, -1minmax LONG format)
       ' '0=all  1=current 2=range
      LOCAL MinPage, MaxPage AS LONG
      MinPage = VAL(MID$(STR$(ABS(PPZoom)),3 TO 5))
      MaxPage = VAL(MID$(STR$(ABS(PPZoom)),6 TO 8))
      SendToPrinter IIF(PPZoom=-1,0,2), MinPage, MaxPage 'if -1 then no range else a range with a min max
      DIALOG END hPPViewPort : DIALOG END hPPDialog
      EXIT SUB
   END IF
   PrintToVisibleGraphic        'shrink image from the hidden graphic control to the visible graphic control
   bail:
   DIALOG SHOW MODELESS hPPViewPort, CALL ViewPortProc
   DIALOG SHOW MODAL hPPDialog CALL PreviewProc()
END SUB

CALLBACK FUNCTION PreviewProc() AS LONG
   LOCAL P AS TooltipText PTR, nmtb AS TBNotify PTR, rc AS Rect, iResult AS LONG
   LOCAL x,y AS LONG
   LOCAL s AS STRING

   'this is the Callback function for the Print Preview dialog.
   SELECT CASE CB.MSG
      CASE %WM_INITDIALOG
         CreatePrintPopupMenu
         PPOldProc = SetWindowLong(GetDlgItem(hPPDialog, %IDC_PrintMinPage), %GWL_WndProc, CODEPTR(PPNewProc))  'subclass
         PPOldProc = SetWindowLong(GetDlgItem(hPPDialog, %IDC_PrintMaxPage), %GWL_WndProc, CODEPTR(PPNewProc))  'subclass
         BuildAcceleratorTable
         SetMenusAndToolbarButtons
         ScrollBarInitialize
         FONT NEW "Tahoma",8,0 TO hPPCFont
         CONTROL SET FONT hPPDialog, %IDC_PrintPageLabel, hPPCFont
         CONTROL SET FONT hPPDialog, %IDC_PrintMinPage, hPPCFont
         CONTROL SET FONT hPPDialog, %IDC_PrintRangeLabel, hPPCFont
         CONTROL SET FONT hPPDialog, %IDC_PrintMaxPage, hPPCFont
         CONTROL SET FONT hPPDialog, %IDC_PrintNumCopies, hPPCFont
         CONTROL SET FONT hPPDialog, %IDC_PPToolbar, hPPCFont
      CASE %WM_SIZE
         'ScrollBarDisplay
         ResizeControls
         PrintToVisibleGraphic
      CASE %WM_HSCROLL     : ScrollBarRespond %SB_HORZ, CB.WPARAM  'respond to horizontal scroll
      CASE %WM_VSCROLL     : ScrollBarRespond %SB_VERT, CB.WPARAM  'respond to vertical scroll
      CASE %WM_MOUSEWHEEL
         SELECT CASE HI(INTEGER,CB.WPARAM)    'note the use of Integer
            CASE > 0
               SendMessage hPPDialog, %WM_VSCROLL, %SB_LINEUP, 0
               SendMessage hPPDialog, %WM_VSCROLL, %SB_LINEUP, 0
               SendMessage hPPDialog, %WM_VSCROLL, %SB_LINEUP, 0
            CASE < 0
               SendMessage hPPDialog, %WM_VSCROLL, %SB_LINEDOWN, 0
               SendMessage hPPDialog, %WM_VSCROLL, %SB_LINEDOWN, 0
               SendMessage hPPDialog, %WM_VSCROLL, %SB_LINEDOWN, 0
         END SELECT
      CASE %WM_NOTIFY
         nmtb = CB.LPARAM
         SELECT CASE @nmtb.hdr.Code
            CASE %TBN_DROPDOWN
               SELECT CASE @nmtb.iItem
                  CASE %IDT_PrintZoom
                       CALL SendMessage(@nmtb.hdr.hwndFrom, %TB_GETRECT, @nmtb.iItem, VARPTR(rc))
                       CALL MapWindowPoints(@nmtb.hdr.hwndFrom, %HWND_DESKTOP, BYVAL VARPTR(rc), 2)
                       CALL TrackPopupMenu (hPopUpPPZoom, 0, rc.nLeft, rc.nBottom, 0, CBHNDL, BYVAL 0)
               END SELECT
         END SELECT
         SELECT CASE CB.NMID
            CASE %IDT_PrinterSelect TO %IDT_PrintClose
                SELECT CASE CB.NMCODE
                   CASE %TTN_GetDispInfo
                      P = CB.LPARAM
                      @P.@lpszText = SetToolTips(CB.NMID)
                END SELECT
         END SELECT
      CASE %WM_COMMAND
         SELECT CASE CB.CTL

            CASE %IDM_PrintTest
                XPRINT ATTACH PPPrinterName
                XPRINT "Printer connection is working!"
                XPRINT CLOSE
                XPRINT ATTACH PPPrinterName

            CASE %IDM_Help 'MSGBOX "gbPrintPreview   v" + $PPVer, %MB_OK + %MB_ICONINFORMATION, "gbPrintPreview"
                   'MLG_SelectAndOpenFile("")

            CASE %IDT_PrintAbout
                   s = "MLG_Print by James Klutho which was based in large part by the code of gbPrintPreview by Gary Beene"
                   MLG_mbox(hPPDialog,s)
                   CONTROL SET FOCUS hPPDialog, %IDC_PrintMinPage

            CASE %IDT_PrintSettings : PrintPageSetup : CONTROL SET FOCUS hPPDialog, %IDC_PrintMinPage

            CASE %IDM_PrintProperties : PrintProperties
            CASE %IDT_PrintAll        : SendToPrinter(0,0,0) : IF PPAutoClose THEN DIALOG END hPPDialog
            CASE %IDT_PrintPage       : SendToPrinter(1,0,0) : IF PPAutoClose THEN DIALOG END hPPDialog
            CASE %IDT_PrintRange      : SendToPrinter(2,0,0) : IF PPAutoClose THEN DIALOG END hPPDialog
            CASE %IDT_PrintClose      : DIALOG END hPPDialog

            CASE %IDT_PrintFirst
               PPCurrentPage = 1
               IF PPCurrentPage < 1 THEN PPCurrentPage = 1
               PrintToHiddenGraphic : PrintToVisibleGraphic
               SetMenusAndToolbarButtons

            CASE %IDT_PrintPrior
               DECR PPCurrentPage
               IF PPCurrentPage < 1 THEN PPCurrentPage = 1
               PrintToHiddenGraphic : PrintToVisibleGraphic
               SetMenusAndToolbarButtons

            CASE %IDT_PrintNext
               INCR PPCurrentPage
               IF PPCurrentPage > PPMaxPages THEN PPCurrentPage = PPMaxPages
               PrintToHiddenGraphic : PrintToVisibleGraphic

            CASE %IDT_PrintLast
               PPCurrentPage  = PPMaxPages
               IF PPCurrentPage > PPMaxPages THEN PPCurrentPage = PPMaxPages
               PrintToHiddenGraphic : PrintToVisibleGraphic


            CASE %IDT_PrintShowMargins
               PPShowMargins = PPShowMargins XOR 1
               PrintToHiddenGraphic : PrintToVisibleGraphic


            CASE %IDT_PrintOrientation
               IF PPOrientation = 1 THEN  PPOrientation = 2 ELSE PPOrientation = 1
               IF PPOrientation = 1 THEN XPRINT SET ORIENTATION 1 ELSE XPRINT SET ORIENTATION 2
               PrintRefresh
               SetMenusAndToolbarButtons

            CASE %IDT_PrintHeader
               PPShowHeader = PPShowHeader XOR 1
               PrintRefresh   'overkill.  resizecontrols, CreateHiddenGraphicControl are not necessary
               SetMenusAndToolbarButtons

            CASE %IDT_PrintFooter
               PPShowFooter = PPShowFooter XOR 1
               PrintRefresh   'overkill.  resizecontrols, CreateHiddenGraphicControl are not necessary
               SetMenusAndToolbarButtons

            CASE %IDT_PrintZoom
               INCR PPZoom
               IF PPZoom > %PPZoom_400 THEN PPZoom = %PPZoom_Page
               ReBuildToolbar
               ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons

            CASE %IDM_PrintZoomPage   : PPZoom = %PPZoom_Page  : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoomWidth  : PPZoom = %PPZoom_Width : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoom25     : PPZoom = %PPZoom_25    : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoom50     : PPZoom = %PPZoom_50    : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoom75     : PPZoom = %PPZoom_75    : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoom100    : PPZoom = %PPZoom_100   : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoom200    : PPZoom = %PPZoom_200   : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons
            CASE %IDM_PrintZoom400    : PPZoom = %PPZoom_400   : ReBuildToolbar : ResizeControls : PrintToVisibleGraphic : SetMenusAndToolbarButtons

            CASE %IDM_PrintHome :  PPCurrentPage = 1          : PrintToHiddenGraphic : PrintToVisibleGraphic
            CASE %IDM_PrintEnd  :  PPCurrentPage = PPMaxPages : PrintToHiddenGraphic : PrintToVisibleGraphic

            CASE %IDM_PrintCut     : SendMessage GetFocus, %WM_CUT, 0, 0
            CASE %IDM_PrintCopy    : SendMessage GetFocus, %WM_COPY, 0, 0
            CASE %IDM_PrintPaste   : SendMessage GetFocus, %WM_PASTE, 0, 0
            CASE %IDM_PrintDelete  : SendMessage GetFocus, %WM_CLEAR, 0, 0

         END SELECT
      CASE %WM_DESTROY
         FONT END hPPFontText
         FONT END hPPFontHeader
         FONT END hPPCFont
         IMAGELIST KILL PPImageList

         FOR x = 0 TO 15
             FOR y = 0 TO 1
                 IF gMLGFonts(x,y)<> 0 THEN DeleteObject(gMLGFonts(x,y))
            NEXT y
         NEXT x

         MENU DELETE hPopupPPZoom, 0
         MENU DELETE hPPPopupContext, 0
         XPRINT CLOSE
        ' CONTROL KILL hPPDialog, %IDC_PrintGraphicHidden
       '  ERASE PPPrintArray
       '  DIALOG END hPPViewPort

         FOR x = 1 TO 13
            IF gToolbarIcon(x) <> 0 THEN
             GRAPHIC ATTACH gToolbarIcon(x),0
             GRAPHIC BITMAP END
             END IF
         NEXT x

         SetWindowLong GetDlgItem(hPPDialog, %IDC_PrintMinPage), %GWL_WNDPROC, PPOldProc   'un-subclass
         SetWindowLong GetDlgItem(hPPDialog, %IDC_PrintMaxPage), %GWL_WNDPROC, PPOldProc   'un-subclass
   END SELECT
END FUNCTION

CALLBACK FUNCTION ViewPortProc() AS LONG
   SELECT CASE CB.MSG
      CASE %WM_INITDIALOG
         ScrollBarInitialize
         '          ShowScrollBar hPPViewPort, %SB_Both, PPScrollBarsVisible
      CASE %WM_HSCROLL   : ScrollBarRespond %SB_HORZ, CB.WPARAM  'respond to horizontal scroll
      CASE %WM_VSCROLL   : ScrollBarrespond %SB_VERT, CB.WPARAM  'respond to vertical scroll
   END SELECT
END FUNCTION

SUB PrintRefresh
   SetPrintPreviewProperties   : ResizeControls
   CreateHiddenGraphicControl  : CreatePrintContent
   PrintToHiddenGraphic        : PrintToVisibleGraphic
END SUB

SUB ResizeControls
   LOCAL w,h AS LONG, sFactor AS SINGLE
   DIALOG SEND hPPDialog, %WM_SetRedraw, 0,0    'turn off draw to prevent flickering

   'resize label (line) and ViewPort dialog
   DIALOG GET CLIENT hPPDialog TO w,h  :  h = h - 60

   'resize hPPViewPort physical size to match hPPDialog
   DIALOG SET SIZE hPPViewPort, w,h           'physical size of hPPViewPort

   'get scroll size of hPPViewPort/ size of the visible graphic (both will be the same)
   SELECT CASE PPZoom
      CASE 1
         sFactor = MAX(PPScreenX*PPScreenPPIx/w, PPScreenY*PPScreenPPIy/h)
         PPSmallImageX = (PPScreenX * PPScreenPPIx) / sFactor * 0.9
         PPSmallImageY = (PPScreenY * PPScreenPPIx) / sFactor * 0.9
         PPScrollSizeX = w  :  PPScrollSizeY = h
      CASE 2
         PPSmallImageX = w - 60
         PPSmallImageY = PPSmallImageX * PPScreenY / PPScreenX
         PPScrollSizeX = w
         PPScrollSizeY = PPSmallImageY + 60  'w * PPScreenY / PPScreenX   'PPSmallImageY + 60
      CASE ELSE
         PPSmallImageX = PPScreenX * PPScreenPPIx * CHOOSE(PPZoom, 1, 1, 0.25, 0.5, 0.75, 1.0, 2.0, 4.0)
         PPSmallImageY = PPScreenY * PPScreenPPIy * CHOOSE(PPZoom, 1, 1, 0.25, 0.5, 0.75, 1.0, 2.0, 4.0)
         PPScrollSizeX = PPSmallImageX + 60
         PPScrollSizeY = PPSmallImageY + 60
         IF PPScrollSizeX < w THEN PPScrollSizeX = w
         IF PPScrollSizeY < h THEN PPScrollSizeY = h
   END SELECT
   PPwMax = PPScrollSizeX : PPhMax = PPScrollSizeY
   ScrollBarInitialize    'set scroll area of hPPViewPort to scaled size of image

   'kill/recreate visible graphic - set to size of scrollable area
   CONTROL KILL hPPViewPort, %IDC_PrintGraphicVisible                                       'kill visible graphic
   CONTROL ADD GRAPHIC, hPPViewPort, %IDC_PrintGraphicVisible, "", 0,0,PPScrollSizeX, PPScrollSizeY  ', %WS_Border
   GRAPHIC ATTACH hPPViewPort, %IDC_PrintGraphicVisible
   GRAPHIC COLOR %BLACK, %RGB_LIGHTGRAY : GRAPHIC CLEAR

END SUB

SUB SetPrintPreviewProperties
   LOCAL tmi AS TextMetric, hDC AS DWORD, w,h AS LONG
   'PPPrinterPPIx, PPPrinterPPIy
   XPRINT GET PPI TO PPPrinterPPIx,PPPrinterPPIy
   XPRINT GET DC TO gPrinterDC

   'PPScreenPPIx, PPScreenPPIy
   GRAPHIC GET PPI TO PPScreenPPIx,PPScreenPPIy

   'PPScreenX, PPScreenY
   XPRINT GET SIZE TO w,h
   PPScreenX = w / PPPrinterPPIx
   PPScreenY = h / PPPrinterPPIy

   'PPDeadZone
   XPRINT GET MARGIN TO PPDeadZoneLeft, PPDeadZoneTop, PPDeadZoneRight, PPDeadZoneBottom
   PPDeadZoneLeft   = PPDeadZoneLeft   / PPPrinterPPIx
   PPDeadZoneTop    = PPDeadZoneTop    / PPPrinterPPIy
   PPDeadZoneRight  = PPDeadZoneRight  / PPPrinterPPIx
   PPDeadZoneBottom = PPDeadZoneBottom / PPPrinterPPIy

   PPPaperX = PPScreenX - PPDeadZoneLeft - PPDeadZoneRight
   PPPaperY = PPScreenY - PPDeadZoneTop - PPDeadZoneBottom

   'PPFooter/PPHeader
   IF PPShowHeader THEN PPHeader = PPHeaderArg  ELSE PPHeader = 0  'depends on custom code that prints the header
   IF PPShowFooter THEN PPFooter = PPFooterArg  ELSE PPFooter = 0  'depends on custom code that prints the footer

   'PPMarginLeft = PPML
   'PPMarginRight = PPMR
   'PPMarginTop = PPMT
   'PPMarginBottom = PPMB

   'Change behavior so that the Margins (in inches) sent to the DLL is the total Gary Beene Margin + DeadZone

   IF gPPML - PPDeadZoneLeft > 0 THEN PPMarginLeft = gPPML - PPDeadZoneLeft ELSE PPMarginLeft = PPDeadZoneLeft
   IF gPPMR - PPDeadZoneRight > 0 THEN PPMarginRight = gPPMR - PPDeadZoneRight ELSE PPMarginRight = PPDeadZoneRight
   IF gPPMT - PPDeadZoneTop > 0 THEN PPMarginTop = gPPMT - PPDeadZoneTop ELSE PPMarginTop = PPDeadZoneTop
   IF gPPMB - PPDeadZoneBottom > 0 THEN PPMarginBottom = gPPMB - PPDeadZoneBottom ELSE PPMarginBottom = PPDeadZoneBottom

   'Maximum printable width and length  PPMaxWidth  PPMaxLength
   PPMaxWidth = PPScreenX - PPDeadZoneLeft - PPDeadZoneRight - PPMarginLeft - PPMarginRight
   PPMaxLength = PPScreenY - PPDeadZoneTop - PPDeadZoneBottom - PPMarginTop - PPMarginBottom - PPHeader - PPFooter  'Added by JEK

   'msgbox str$(PPMaxWidth) + str$(PPMaxLength)

   'PPLinesPerPage
   GRAPHIC SET FONT hPPFontText
   GRAPHIC CLEAR
   GRAPHIC TEXT SIZE "A" TO w,h

   GRAPHIC GET DC TO hDC
   GetTextMetrics hDC, tmi
   h = tmi.tmExternalLeading + tmi.tmHeight

   PPLinesPerPage = (PPScreenY - PPDeadZoneTop - PPDeadZoneBottom - PPHeader - PPFooter - PPMarginTop - PPMarginBottom) * PPScreenPPIy / h
END SUB

SUB CreateHiddenGraphicControl
   CONTROL KILL hPPDialog, %IDC_PrintGraphicHidden
   CONTROL ADD GRAPHIC, hPPDialog, %IDC_PrintGraphicHidden, "", 500,0,PPScreenX*PPScreenPPIx,PPScreenY*PPScreenPPIy, %WS_BORDER
   CONTROL SHOW STATE hPPDialog, %IDC_PrintGraphicHidden, %SW_HIDE
END SUB

SUB CreatePrintContent
   'this routine would be custom for every application
   LOCAL w,h,temp1,temp2 AS LONG, PPTempText AS STRING

   GRAPHIC ATTACH hPPDialog, %IDC_PrintGraphicHidden
   GRAPHIC FONT PPFontName, PPFontPoints, PPFontStyle
   GRAPHIC CLEAR
   GRAPHIC GET DC TO gGraphicDC

   MLG_CreateFont 0
   MLG_CreateFont 1
   MLG_CalcPages(1)

  ' gPrintMin = PPHIW
  ' gPrintMax = PPHIH
  temp1 = PPCurrentPage
  IF gPrintMin > PPCurrentPage THEN temp1 = gPrintMin
  IF gPrintMin > PPMaxPages THEN temp1 = PPMaxPages
  temp2 = PPMaxPages
  IF gPrintMax <> 0 THEN
      temp2 = MIN(gPrintMax,PPMaxPages)
  END IF


   CONTROL SET TEXT hPPDialog, %IDC_PrintMinPage, STR$(temp1)
   CONTROL SET TEXT hPPDialog, %IDC_PrintMaxPage, STR$(temp2)

   'put text into array for printing
   CONTROL GET SIZE hPPDialog, %IDC_PrintGraphicHidden TO w,h
  ' IF PPWordWrap THEN PPTempText = WORDWRAP(PPText, %True) ELSE PPTempText = PPText
   PPTempText = PPText
 '  REDIM PPPrintArray(PARSECOUNT(PPTempText, $CRLF)-1)
 '  PARSE PPTempText, PPPrintArray(), $CRLF
 '  PPMaxPages = (UBOUND(PPPrintArray)\PPLinesPerPage)
 '  IF UBOUND(PPPrintArray) MOD PPLinesPerPage THEN PPMaxPages = PPMaxPages + 1
END SUB


SUB PrintToHiddenGraphic
   'confirm current page exists
   IF PPCurrentPage > PPMaxPages THEN PPCurrentPage = 1
'
'   'display page number being printed
   CONTROL SET TEXT hPPDialog, %IDC_PrintPageLabel, STR$(PPCurrentPage)
'
'   'select the hidden graphic control
   GRAPHIC ATTACH hPPDialog, %IDC_PrintGraphicHidden
   GRAPHIC FONT PPFontName, PPFontPoints, PPFontStyle
   GRAPHIC COLOR %BLACK, %WHITE
   GRAPHIC CLEAR
'
   IF PPShowHeader THEN PrintHeader          'print header
   MLG_PrintGrid 0                               'print text
   IF PPShowFooter THEN PrintFooter          'print footer
   IF PPShowMargins THEN PrintMarginOutline  'print outline
END SUB

SUB MLG_PrintGrid(SorP AS LONG,OPT BYVAL whichpage AS LONG)
   'print only the lines for the specified page
   'SorP stands for "Screen or Printer" 0 = Screen else Printer

   LOCAL FirstLine, LastLine, i, j, x, y,ii,jj,PrintCheckx,PrintChecky  AS LONG
   LOCAL t,l,b,r,h,v AS SINGLE
   LOCAL str AS STRING
   LOCAL Sptr AS STRING POINTER
   LOCAL slen,whichfont,TotGRectRRFlag,TotGRectRCFlag AS LONG
   LOCAL DrawRect,TempRect,GRect,FRect,GRectRH,GRectCH,FRectRH,FRectCH,TotGRect,TotGRectRR,TotGRectRC AS RECT
   LOCAL GRectRR,FRectRR,GRectRC,FRectRC AS RECT
   LOCAL OldTA,MyhDC AS LONG
   LOCAL myrowStart,myrowEnd,mycolStart,mycolEnd,tempdt,MyTextColor,MyBkgndColor,MyFont,foTempBrush,DTVC AS LONG
   LOCAL rowcolstr,mycell AS STRING
   LOCAL MLGStartTop,MLGStartLeft,MyJust AS LONG  'DrawRect of Print File Cell
   LOCAL MySolidLine,MySolidLine2,MySolidLine3,hollowbrush AS DWORD
   LOCAL lb AS logbrush
   LOCAL Cellborder AS BYTE
   LOCAL MyXScale,MyYScale AS SINGLE
   LOCAL repeatrowcount,repeatcolcount,RepeatRowStart,RepeatColStart,temp4,temp3,DrawFlag AS LONG
   LOCAL MLGRepeatStartTop,MLGRepeatStartLeft AS LONG
   LOCAL MyRepeatColRectNum, MyRepeatRowRectNum AS LONG
   DIM MyRepeatColRect(4) AS RECT
   DIM MyRepeatRowRect(4) AS RECT
   LOCAL hBmpcheckbox,xhDC_check,xscrDC_check AS DWORD


   IF whichpage = 0 THEN
      rowcolstr=gPages(PPCurrentPage)  'we have page preview
     ELSE
      rowcolstr=gPages(whichpage)  'we have printing
   END IF

   myrowStart=VAL(PARSE$(PARSE$(rowcolstr,$MLGP,1),1))
   myrowEnd=VAL(PARSE$(PARSE$(rowcolstr,$MLGP,1),2))
   mycolStart=VAL(PARSE$(PARSE$(rowcolstr,$MLGP,2),1))
   mycolEnd=VAL(PARSE$(PARSE$(rowcolstr,$MLGP,2),2))

   mycell=UNWRAP$(gMLGsdata(myrowStart,1),$DQ,$DQ) : i = VAL(PARSE$(mycell,$MLGP,3))
   mycell=UNWRAP$(gMLGsdata(myrowEnd,1),$DQ,$DQ) : ii = VAL(PARSE$(mycell,$MLGP,5))
   mycell=UNWRAP$(gMLGsdata(1,mycolStart),$DQ,$DQ) : j = VAL(PARSE$(mycell,$MLGP,4))
   mycell=UNWRAP$(gMLGsdata(1,mycolEnd),$DQ,$DQ) : jj = VAL(PARSE$(mycell,$MLGP,6))

   IF gPrintVertCentering = 1 THEN
      v=ii-i + 1
      v = ABS(((PPMaxLength * PPScreenPPIy)-v)\2)
   END IF


   IF gPrintHorzCentering = 1 THEN
      h=jj-j + 1
      h = ABS(((PPMaxWidth * PPScreenPPIx)-h)\2)
   END IF


   mycell=gMLGsdata(myrowStart,mycolStart)
   MLGStartTop = VAL(PARSE$(mycell,$MLGP,3))
   MLGStartLeft = VAL(PARSE$(mycell,$MLGP,4))

   IF SorP = 0 THEN
       l=PPScreenPPIx * (PPDeadZoneLeft + PPMarginLeft) + h
       t=PPScreenPPIy * (PPDeadZoneTop + PPMarginTop + PPHeader) + v
    ELSE
       l=PPScreenPPIx * (PPMarginLeft) + h
       t=PPScreenPPIy * (PPMarginTop + PPHeader) + v
  END IF

   l = l + 1
   t = t + 1

   IF PPShowRowColHeaders <> 0 THEN  '0 = none, 3 is both, 1 is row only, 2 is col only
       IF PPShowRowColHeaders = 1 OR PPShowRowColHeaders = 3 THEN  l = l + gMLGColHeaderWidth * PPScreenPPIx
       IF PPShowRowColHeaders = 2 OR PPShowRowColHeaders = 3 THEN  t = t + gMLGRowHeaderHeight * PPScreenPPIy
       RepeatRowStart = t
       RepeatColStart = l
     ELSE
       RepeatRowStart = t
       RepeatColStart = l
   END IF

   IF gMLGRowRepeatHeight <> 0  OR gMLGColRepeatWidth <> 0 THEN
       IF gMLGRowRepeatHeight > 0  THEN  t = t + gMLGRowRepeatHeight * PPScreenPPIy
       IF gMLGColRepeatWidth > 0   THEN  l = l + gMLGColRepeatWidth * PPScreenPPIx
   END IF

   'Used for Grid Clipping
   TotGRect.nTop = t
   TotGRect.nLeft = l
   TotGRect.nBottom = t + (ii-i)+1
   TotGRect.nRight = l + (jj-j)+5

   IF SorP = 0 THEN
       MyhDC = gGraphicDC
       MyXScale = 1
       MyYScale = 1
       whichfont = 1
    ELSE
       MyhDC = gPrinterDC
       MyXScale = PPPrinterPPIx/PPScreenPPIx
       MyYScale = PPPrinterPPIy/PPScreenPPIy
       whichfont = 0
   END IF

   MySolidLine=CreatePen(%PS_SOLID,1 * MyXScale,RGB(192,192,192)) 'For Gridlines
   MySolidLine2=CreatePen(%PS_SOLID,2 * MyXScale,RGB(0,0,0)) 'For borders
   MySolidLine3=CreatePen(%PS_SOLID,1 * MyXScale,RGB(0,0,0)) 'For Gridlines

   OldTA=GetTextAlign (MyhDC)
   SetTextAlign MyhDC,%TA_LEFT OR %TA_NOUPDATECP OR %TA_TOP

   SelectObject MyhDC, MySolidLine
   hollowbrush = GetStockObject(%HOLLOW_BRUSH)
   SelectObject MyhDC, hollowbrush

   SelectObject MyhDC, gMLGFonts(2,whichfont)

   hBmpcheckbox = LoadBitmap(0, BYVAL %OBM_CHECKBOXES) 'for checkboxes

   xhDC_check      = GetDC(MyhDC)
   xscrDC_check    = CreateCompatibleDC(xhdc_check)
   ReleaseDC MyhDC, xhDC_check
   ' now get the checkbox bitmaps ready to use
   SelectObject xscrDC_check, hBmpcheckbox
   PrintCheckx = 13 * (PPPrinterPPIx/PPScreenPPIx)
   PrintChecky = 13 * (PPPrinterPPIy/PPScreenPPIy)

   FOR x = mycolStart TO mycolEnd
       FOR y = myrowStart TO myrowEnd

           mycell=UNWRAP$(gMLGsdata(y,x),$DQ,$DQ)
           tempdt = VAL(PARSE$(mycell,$MLGP,1))
           'test for DT_VCENTER for row headers
           IF ( tempdt AND %DT_VCENTER ) = %DT_VCENTER THEN DTVC = %DT_VCENTER ELSE DTVC = 0
           Drawflag = VAL(PARSE$(mycell,$MLGP,2))
           i = VAL(PARSE$(mycell,$MLGP,3))
           j = VAL(PARSE$(mycell,$MLGP,4))
           ii = VAL(PARSE$(mycell,$MLGP,5))
           jj = VAL(PARSE$(mycell,$MLGP,6))
           MyJust = VAL(PARSE$(mycell,$MLGP,7))
           MyTextColor = VAL(PARSE$(mycell,$MLGP,8))
           MyBkgndColor = VAL(PARSE$(mycell,$MLGP,9))
           CellBorder = CBYT(VAL(PARSE$(mycell,$MLGP,10)))
           MyFont = VAL(PARSE$(mycell,$MLGP,11))
           str = PARSE$(mycell,$MLGP,12)

           DrawRect.nTop = t + i - MLGStartTop
           DrawRect.nLeft = l + j - MLGStartLeft + 2
           DrawRect.nBottom = t + ii - MLGStartTop + 1
           DrawRect.nRight = l + jj - MLGStartLeft + 5

           CopyRect GRect,DrawRect
           GRect.nTop  = GRect.nTop * MyYScale
           GRect.nLeft  = GRect.nLeft * MyXScale
           GRect.nBottom  = GRect.nBottom * MyYScale
           GRect.nRight  = GRect.nRight * MyXScale

           CopyRect FRect,DrawRect
           FRect.nLeft = FRect.nLeft - 2
           FRect.nTop  = FRect.nTop * MyYScale
           FRect.nLeft  = FRect.nLeft * MyXScale
           FRect.nBottom  = FRect.nBottom * MyYScale
           FRect.nRight  = FRect.nRight * MyXScale

           'if x=1 and y=1 and whichfont = 0 then msgbox str$(FRect.nRight)


           SelectObject MyhDC, gMLGFonts(MyFont,whichfont)
           SetBkColor MyhDC, MyBkgndColor
           SetTextColor MyhDC, MyTextColor
           SelectObject MyhDC, MySolidLine


           'make a brush
           lb.lbstyle=%BS_SOLID
           lb.lbcolor=MyBkgndColor
           foTempBrush=CreateBrushIndirect(lb)
           FillRect MyhDC,FRect,foTempBrush
           SetBkColor MyhDC, MyBkgndColor
           DeleteObject foTempBrush

           IF MyJust = 3 THEN 'Wordwrap
               tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_WORDBREAK
             ELSE 'No Wordwrap
               tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_SINGLELINE
           END IF


            'Search for $CRLF for DT_SINGLELINE or DT_WORDWRAP

           IF MyFont = %MLGSYSFONTNORMVERT OR MyFont = %MLGSYSFONTBOLDVERT THEN
                MLG_DrawTextVert(MyhDC,str,MyFont,GRect,MyJust,whichfont,MyXScale,MyYScale)
            ELSE
                IF DrawFlag = 0 THEN
                    'IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),GRect,%DT_EDITCONTROL OR tempdt OR %DT_NOPREFIX  OR %DT_SINGLELINE
                    IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),GRect,tempdt
                 ELSEIF DrawFlag = -1 THEN
                    ' msgbox "HERE"
                     temp4=((DrawRect.nBottom) - (DrawRect.nTop)-12)\2 : temp4=MAX&(temp4,0)
                     temp3=((DrawRect.nRight-DrawRect.nLeft)\2) - 7
                     temp3 = temp3 * MyXScale
                     temp4 = temp4 * MyYScale
                     IF LEN(str)>0 THEN
                         IF SorP = 0 THEN
                              BitBlt MyhDC, GRect.nLeft+temp3, GRect.nTop+temp4, 13,13,xscrDC_check, 13, 0, %SRCCOPY 'checked
                           ELSE 'printer
                              StretchBlt MyhDC,GRect.nLeft+temp3, GRect.nTop+temp4,PrintCheckx, PrintChecky, xscrDC_check, 13, 0,12,12, %SRCCOPY
                         END IF
                      ELSE
                         IF SorP = 0 THEN
                              BitBlt MyhDC, GRect.nLeft+temp3,GRect.nTop+temp4, 13,13,xscrDC_check, 0, 0, %SRCCOPY 'unchecked
                           ELSE 'printer
                              StretchBlt MyhDC,GRect.nLeft+temp3, GRect.nTop+temp4,PrintCheckx, PrintChecky, xscrDC_check, 0, 0,12,12, %SRCCOPY
                        END IF
                     END IF
               END IF
           END IF
           IF gGridlines = 0 THEN Rectangle MyhDC,FRect.nLeft,FRect.nTop, FRect.nRight,FRect.nBottom

          ' CopyRect TempRect,DrawRect

          'goto bail
           '-------------------Now do the repeat rows and columns if they show-------------------------
            IF gMLGRowRepeatHeight <> 0  OR gMLGColRepeatWidth <> 0 THEN
                   IF gMLGRowRepeatHeight > 0  THEN

                       IF y = myrowStart THEN

                           FOR repeatrowcount = (gMLGUBoundy + 2) TO (gMLGUBoundy + 1 + gMLGUBoundRowsy)
                               INCR MyRepeatRowRectNum
                                ' Msgbox "HERE"
                               mycell=UNWRAP$(gMLGsdata(repeatrowcount,x),$DQ,$DQ)
                               tempdt = VAL(PARSE$(mycell,$MLGP,1))
                               'test for DT_VCENTER for row headers
                               IF(tempdt AND %DT_VCENTER ) = %DT_VCENTER THEN DTVC = %DT_VCENTER ELSE DTVC = 0
                               DrawFlag = VAL(PARSE$(mycell,$MLGP,2))
                               i = VAL(PARSE$(mycell,$MLGP,3))
                               j = VAL(PARSE$(mycell,$MLGP,4))
                               ii = VAL(PARSE$(mycell,$MLGP,5))
                               jj = VAL(PARSE$(mycell,$MLGP,6))
                               MyJust = VAL(PARSE$(mycell,$MLGP,7))
                               MyTextColor = VAL(PARSE$(mycell,$MLGP,8))
                               MyBkgndColor = VAL(PARSE$(mycell,$MLGP,9))
                               CellBorder = CBYT(VAL(PARSE$(mycell,$MLGP,10)))
                               MyFont = VAL(PARSE$(mycell,$MLGP,11))
                               str = PARSE$(mycell,$MLGP,12)
                              ' str = str$(repeatrowcount)


                               IF MyJust = 3 THEN 'Wordwrap
                                   tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_WORDBREAK
                                 ELSE 'No Wordwrap
                                   tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_SINGLELINE
                               END IF

                               SelectObject MyhDC, gMLGFonts(MyFont,whichfont)
                               SetBkColor MyhDC, MyBkgndColor
                               SetTextColor MyhDC, MyTextColor
                               SelectObject MyhDC, MySolidLine

                               MLGRepeatStartTop = VAL(PARSE$(gMLGsdata(1,1),$MLGP,3))
                               MLGRepeatStartLeft = VAL(PARSE$(gMLGsdata(1,1),$MLGP,4))

                               DrawRect.nTop = RepeatRowStart + i - MLGRepeatStartTop
                               DrawRect.nLeft = RepeatColStart + j - MLGRepeatStartLeft + 2 + (gMLGColRepeatWidth * PPScreenPPIx)
                               DrawRect.nBottom = RepeatRowStart + ii - MLGRepeatStartTop + 1
                               DrawRect.nRight = RepeatColStart + jj - MLGRepeatStartLeft + 5 + (gMLGColRepeatWidth * PPScreenPPIx)


                               CopyRect GRectRR,DrawRect
                               GRectRR.nTop  = GRectRR.nTop * MyYScale
                               GRectRR.nLeft  = GRectRR.nLeft * MyXScale
                               GRectRR.nBottom  = GRectRR.nBottom * MyYScale
                               GRectRR.nRight  = GRectRR.nRight * MyXScale

                                GRectRR.nLeft  = GRect.nLeft
                                GRectRR.nRight  = GRect.nRight

                               CopyRect FRectRR,DrawRect
                               FRectRR.nLeft = FRectRR.nLeft - 2
                               FRectRR.nTop  = FRectRR.nTop * MyYScale
                               FRectRR.nLeft  = FRectRR.nLeft * MyXScale
                               FRectRR.nBottom  = FRectRR.nBottom * MyYScale
                               FRectRR.nRight  = FRectRR.nRight * MyXScale

                                FRectRR.nLeft  = FRect.nLeft
                                FRectRR.nRight  = FRect.nRight

                             '  LOCAL hh AS LONG
                             '  IF hh = 0 THEN MSGBOX STR$(FRectRR.nTop) + STR$(FRectRR.nLeft) +STR$(FRectRR.nBottom) +STR$(FRectRR.nRight)   : hh = 1


                               IF repeatrowcount = (gMLGUBoundy + 1 + gMLGUBoundRowsy)  THEN

                                  FRectRR.nBottom = FRect.nTop
                               END IF

                             'make a brush
                             lb.lbstyle=%BS_SOLID
                             lb.lbcolor=MyBkgndColor
                             foTempBrush=CreateBrushIndirect(lb)
                             FillRect MyhDC,FRectRR,foTempBrush
                             SetBkColor MyhDC, MyBkgndColor
                             DeleteObject foTempBrush

                              IF MyFont = %MLGSYSFONTNORMVERT OR MyFont = %MLGSYSFONTBOLDVERT THEN
                                    MLG_DrawTextVert(MyhDC,str,MyFont,GRect,MyJust,whichfont,MyXScale,MyYScale)
                                ELSE
                                    IF DrawFlag = 0 THEN
                                        IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),GRectRR,%DT_EDITCONTROL OR tempdt OR %DT_NOPREFIX  OR %DT_SINGLELINE
                                     ELSEIF DrawFlag = -1 THEN
                                         temp4=((DrawRect.nBottom) - (DrawRect.nTop)-12)\2 : temp4=MAX&(temp4,0)
                                         temp3=((DrawRect.nRight-DrawRect.nLeft)\2) - 7
                                         temp3 = temp3 * MyXScale
                                         temp4 = temp4 * MyYScale
                                         IF LEN(str)>0 THEN
                                             IF SorP = 0 THEN
                                                  BitBlt MyhDC, GRectRR.nLeft+temp3, GRectRR.nTop+temp4, 13,13,xscrDC_check, 13, 0, %SRCCOPY 'checked
                                               ELSE 'printer
                                                  StretchBlt MyhDC,GRectRR.nLeft+temp3, GRectRR.nTop+temp4,PrintCheckx, PrintChecky, xscrDC_check, 13, 0,12,12, %SRCCOPY
                                             END IF
                                          ELSE
                                             IF SorP = 0 THEN
                                                  BitBlt MyhDC, GRectRR.nLeft+temp3,GRectRR.nTop+temp4, 13,13,xscrDC_check, 0, 0, %SRCCOPY 'unchecked
                                               ELSE 'printer
                                                  StretchBlt MyhDC,GRectRR.nLeft+temp3, GRectRR.nTop+temp4,PrintCheckx, PrintChecky, xscrDC_check, 0, 0,12,12, %SRCCOPY
                                            END IF
                                         END IF
                                   END IF
                               END IF
                               IF gGridlines = 0 THEN Rectangle MyhDC,FRectRR.nLeft,FRectRR.nTop, FRectRR.nRight,FRectRR.nBottom
                               'Used for clipping  - This catches the first time thru
                               IF TotGRectRRFlag = 0 THEN
                                   TotGRectRR.nTop = FRectRR.nTop
                                   TotGRectRR.nLeft = FRectRR.nLeft
                                   TotGRectRRFlag = 1
                               END IF
                           NEXT repeatrowcount
                       END IF

                      'Used for clipping - update each time thru - the last one will be the one we want

                       TotGRectRR.nBottom = FRectRR.nBottom
                       TotGRectRR.nRight = FRectRR.nRight


                   END IF

                   IF gMLGColRepeatWidth > 0   THEN

                       CopyRect TempRect,DrawRect


                       IF x = mycolStart THEN

                           FOR repeatcolcount = (gMLGUBoundx + 2) TO (gMLGUBoundx + 1 + gMLGUBoundColsx)
                               'MSGBOX STR$(repeatrowcount)+STR$(x) + " ; " + gMLGsdata(repeatrowcount,x)
                               mycell=UNWRAP$(gMLGsdata(y,repeatcolcount),$DQ,$DQ)
                               tempdt = VAL(PARSE$(mycell,$MLGP,1))
                               DrawFlag = VAL(PARSE$(mycell,$MLGP,2))
                               'test for DT_VCENTER for row headers
                               IF(tempdt AND %DT_VCENTER ) = %DT_VCENTER THEN DTVC = %DT_VCENTER ELSE DTVC = 0
                               i = VAL(PARSE$(mycell,$MLGP,3))
                               j = VAL(PARSE$(mycell,$MLGP,4))
                               ii = VAL(PARSE$(mycell,$MLGP,5))
                               jj = VAL(PARSE$(mycell,$MLGP,6))
                               MyJust = VAL(PARSE$(mycell,$MLGP,7))
                               MyTextColor = VAL(PARSE$(mycell,$MLGP,8))
                               MyBkgndColor = VAL(PARSE$(mycell,$MLGP,9))
                               CellBorder = CBYT(VAL(PARSE$(mycell,$MLGP,10)))
                               MyFont = VAL(PARSE$(mycell,$MLGP,11))
                               str = PARSE$(mycell,$MLGP,12)

                               IF MyJust = 3 THEN 'Wordwrap
                                   tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_WORDBREAK
                                 ELSE 'No Wordwrap
                                   tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_SINGLELINE
                               END IF

                               SelectObject MyhDC, gMLGFonts(MyFont,whichfont)
                               SetBkColor MyhDC, MyBkgndColor
                               SetTextColor MyhDC, MyTextColor
                               SelectObject MyhDC, MySolidLine

                               MLGRepeatStartTop = VAL(PARSE$(gMLGsdata(1,1),$MLGP,3))
                               MLGRepeatStartLeft = VAL(PARSE$(gMLGsdata(1,1),$MLGP,4))

                               DrawRect.nTop = RepeatRowStart + i - MLGRepeatStartTop   + (gMLGRowRepeatHeight * PPScreenPPIy)
                               DrawRect.nLeft = RepeatColStart + j - MLGRepeatStartLeft + 2
                               DrawRect.nBottom = RepeatRowStart + ii - MLGRepeatStartTop + 1  + (gMLGRowRepeatHeight * PPScreenPPIy)
                               DrawRect.nRight = RepeatColStart + jj - MLGRepeatStartLeft + 5

                               CopyRect GRectRC,DrawRect
                               GRectRC.nTop  = GRectRC.nTop * MyYScale
                               GRectRC.nLeft  = GRectRC.nLeft * MyXScale
                               GRectRC.nBottom  = GRectRC.nBottom * MyYScale
                               GRectRC.nRight  = GRectRC.nRight * MyXScale

                               GRectRC.nTop  = GRect.nTop
                               GRectRC.nRight  = GRect.nLeft
                               GRectRC.nBottom  = GRect.nBottom

                               CopyRect FRectRC,DrawRect
                               FRectRC.nLeft = FRectRC.nLeft - 2
                               FRectRC.nTop  = FRectRC.nTop * MyYScale
                               FRectRC.nLeft  = FRectRC.nLeft * MyXScale
                               FRectRC.nBottom  = FRectRC.nBottom * MyYScale
                               FRectRC.nRight  = FRectRC.nRight * MyXScale

                               FRectRC.nTop  = FRect.nTop
                               FRectRC.nRight  = FRect.nLeft
                               FRectRC.nBottom  = FRect.nBottom


                             'make a brush
                             lb.lbstyle=%BS_SOLID
                             lb.lbcolor=MyBkgndColor
                             foTempBrush=CreateBrushIndirect(lb)
                             FillRect MyhDC,FRectRC,foTempBrush
                             SetBkColor MyhDC, MyBkgndColor
                             DeleteObject foTempBrush


                             IF MyFont = %MLGSYSFONTNORMVERT OR MyFont = %MLGSYSFONTBOLDVERT THEN
                                    MLG_DrawTextVert(MyhDC,str,MyFont,GRect,MyJust,whichfont,MyXScale,MyYScale)
                                ELSE
                                    IF DrawFlag = 0 THEN
                                         'IF hh = 0 THEN MSGBOX STR$(FRectRC.nTop) + STR$(FRectRC.nLeft) +STR$(FRectRC.nBottom) +STR$(FRectRC.nRight)   : hh = 1
                                        IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),GRectRC,%DT_EDITCONTROL OR tempdt OR %DT_NOPREFIX  OR %DT_SINGLELINE
                                     ELSEIF DrawFlag = -1 THEN
                                         temp4=((DrawRect.nBottom) - (DrawRect.nTop)-12)\2 : temp4=MAX&(temp4,0)
                                         temp3=((DrawRect.nRight-DrawRect.nLeft)\2) - 7
                                         temp3 = temp3 * MyXScale
                                         temp4 = temp4 * MyYScale
                                         IF LEN(str)>0 THEN
                                             IF SorP = 0 THEN
                                                  BitBlt MyhDC, GRectRC.nLeft+temp3, GRectRC.nTop+temp4, 13,13,xscrDC_check, 13, 0, %SRCCOPY 'checked
                                               ELSE 'printer
                                                  StretchBlt MyhDC,GRectRC.nLeft+temp3, GRectRC.nTop+temp4,PrintCheckx, PrintChecky, xscrDC_check, 13, 0,12,12, %SRCCOPY
                                             END IF
                                          ELSE
                                             IF SorP = 0 THEN
                                                  BitBlt MyhDC, GRectRC.nLeft+temp3,GRectRC.nTop+temp4, 13,13,xscrDC_check, 0, 0, %SRCCOPY 'unchecked
                                               ELSE 'printer
                                                  StretchBlt MyhDC,GRectRC.nLeft+temp3, GRectRC.nTop+temp4,PrintCheckx, PrintChecky, xscrDC_check, 0, 0,12,12, %SRCCOPY
                                            END IF
                                         END IF
                                   END IF
                               END IF
                             IF gGridlines = 0 THEN Rectangle MyhDC,FRectRC.nLeft,FRectRC.nTop, FRectRC.nRight,FRectRC.nBottom
                              'Used for clipping - This catches the first time thru
                               IF TotGRectRCFlag = 0 THEN
                                   TotGRectRC.nTop = FRectRC.nTop
                                   TotGRectRC.nLeft = FRectRC.nLeft
                                   TotGRectRCFlag = 1
                               END IF
                           NEXT repeatcolcount

                       END IF

                       'Used for clipping - update each time thru - the last one will be the one we want
                       TotGRectRC.nBottom = FRectRC.nBottom
                       TotGRectRC.nRight = FRectRC.nRight

                   END IF
           END IF


           '-------------------Now do the headers if they show-------------------------

           SelectObject MyhDC, MySolidLine3
           IF PPShowRowColHeaders <> 0 THEN
               SetBkColor MyhDC, %WHITE
               SetTextColor MyhDC, %BLACK

             '  CopyRect TempRect,DrawRect

               tempdt = %DT_CENTER OR %DT_NOPREFIX OR %DT_VCENTER
               IF y = myrowStart THEN
                   IF PPShowRowColHeaders = 2 OR PPShowRowColHeaders = 3 THEN
                       SelectObject MyhDC, gMLGFonts(1,whichfont)
                       mycell=UNWRAP$(gMLGsdata(0,x),$DQ,$DQ)
                       str = PARSE$(mycell,$MLGP,4)

                       CopyRect GRectCH,GRect
                       GRectCH.nBottom  = GRect.nTop - ((gMLGRowRepeatHeight * PPScreenPPIy) * MyYScale)
                       GRectCH.nTop  = (PPScreenPPIy * (PPDeadZoneTop + PPMarginTop + PPHeader)+1)  * MyYScale

                       CopyRect FRectCH,FRect
                       FRectCH.nBottom  = FRect.nTop - ((gMLGRowRepeatHeight * PPScreenPPIy) * MyYScale)
                       FRectCH.nTop  = (PPScreenPPIy * (PPDeadZoneTop + PPMarginTop + PPHeader)+1)  * MyYScale

                        'make a brush
                       lb.lbstyle=%BS_SOLID
                       lb.lbcolor=%WHITE
                       foTempBrush=CreateBrushIndirect(lb)
                       FillRect MyhDC,FRectCH,foTempBrush
                       SetBkColor MyhDC, %WHITE
                       DeleteObject foTempBrush

                       DrawText MyhDC,BYVAL STRPTR(str), LEN(str),GRectCH,%DT_EDITCONTROL OR tempdt OR %DT_NOPREFIX  OR %DT_SINGLELINE
                       Rectangle MyhDC,FRectCH.nLeft,FRectCH.nTop, FRectCH.nRight,FRectCH.nBottom

                   END IF
               END IF

               'CopyRect DrawRect,TempRect
              ' CopyRect TempRect,DrawRect

               tempdt =%DT_RIGHT OR %DT_NOPREFIX  OR %DT_SINGLELINE OR DTVC
               IF x = mycolStart THEN
                   IF PPShowRowColHeaders = 1 OR PPShowRowColHeaders = 3 THEN
                       SelectObject MyhDC, gMLGFonts(1,whichfont)
                       mycell=UNWRAP$(gMLGsdata(y,0),$DQ,$DQ)
                       str = PARSE$(mycell,$MLGP,4)


                        CopyRect GRectRH,GRect
                        GRectRH.nRight = GRect.nLeft - (3 *  MyXScale)  - ((gMLGColRepeatWidth * PPScreenPPIx) * MyXScale)
                        GRectRH.nLeft = ((PPScreenPPIx*(PPDeadZoneLeft + PPMarginLeft))+ 3) * MyXScale

                        CopyRect FRectRH,FRect
                        FRectRH.nLeft = ((PPScreenPPIx*(PPDeadZoneLeft + PPMarginLeft))+ 1) * MyXScale
                        FRectRH.nRight = FRect.nLeft - ((gMLGColRepeatWidth * PPScreenPPIx) * MyXScale)


                       'make a brush
                       lb.lbstyle=%BS_SOLID
                       lb.lbcolor=%WHITE
                       foTempBrush=CreateBrushIndirect(lb)
                       FillRect MyhDC,FRectRH,foTempBrush
                       SetBkColor MyhDC, %WHITE
                       DeleteObject foTempBrush

                       DrawText MyhDC,BYVAL STRPTR(str), LEN(str),GRectRH,%DT_EDITCONTROL OR tempdt OR %DT_NOPREFIX  OR %DT_SINGLELINE
                       Rectangle MyhDC,FRectRH.nLeft,FRectRH.nTop,FRectRH.nRight,FRectRH.nBottom

                   END IF
               END IF

           END IF

           'now do borders
           IF CellBorder > 0 THEN
               SelectObject MyhDC, MySolidLine2
               IF (CellBorder AND &B00001000) = 8 THEN  'TOP 8
                 MoveTo (MyhDC,(DrawRect.nLeft-1) * MyXScale ,(DrawRect.nTop-1) * MyYScale) : LineTo MyhDC,(DrawRect.nRight-2) * MyXScale,(DrawRect.nTop-1) * MyYScale
               END IF

               IF (CellBorder AND &B00000100) = 4 THEN  'LEFT 4
                 MoveTo (MyhDC,(DrawRect.nLeft-1) * MyXScale,(DrawRect.nTop-1) * MyYScale) : LineTo MyhDC,(DrawRect.nLeft-1) * MyXScale,(DrawRect.nBottom -2) * MyYScale
               END IF

               'Since cells to the Right and Bottom over write the grid -
               'Draw TOP of the North Cell as though it was the bottom of the current cell
               'Draw LEFT of the West Cell as though it was the right of the current cell

               IF (CellBorder AND &B00000010) = 2 THEN  'BOTTOM 2
                 MoveTo (MyhDC,(DrawRect.nLeft-1) * MyXScale,(DrawRect.nBottom-2) * MyYScale) : LineTo MyhDC,(DrawRect.nRight-2) * MyXScale,(DrawRect.nBottom-2) * MyYScale
               END IF

               IF (CellBorder AND &B00000001) = 1 THEN   'RIGHT 1
                 MoveTo (MyhDC,(DrawRect.nRight-2) * MyXScale,(DrawRect.nTop-1) * MyYScale) : LineTo MyhDC,(DrawRect.nRight-2) * MyXScale,(DrawRect.nBottom -2) * MyYScale
               END IF

           END IF
          bail:
      NEXT y
   NEXT x

   SetBkColor MyhDC, %WHITE
   SetTextColor MyhDC, %BLACK

  '  SelectObject MyhDC, MySolidLine3
  '  Rectangle MyhDC,TotGRectRC.nLeft,TotGRectRC.nTop,TotGRectRC.nRight,TotGRectRC.nBottom

   SetTextAlign MyhDC,OldTA
   DeleteObject MySolidLine
   DeleteObject MySolidLine2
   DeleteObject MySolidLine3
   DeleteObject hollowbrush
   DeleteObject hBmpcheckbox
   DeleteDC xscrDC_check



   MLG_PrintObjects(MyhDC,TotGRect,TotGRectRR,TotGRectRC,whichfont,MyXScale,MyYScale)
END SUB

SUB MLG_PrintObjects(MyhDC AS DWORD,TotGRect AS RECT,TotGRectRR AS RECT,TotGRectRC AS RECT,whichfont AS LONG,xscale AS SINGLE, yscale AS SINGLE)
   LOCAL MyRectRgn,MyRectRgn2 AS LONG
   LOCAL i, j, x, y,ii,jj  AS LONG

   LOCAL str AS STRING
   LOCAL Sptr AS STRING POINTER
   LOCAL OldTA,xoffset,yoffset,WhichObject AS LONG
   LOCAL myrowStart,myrowEnd,mycolStart,mycolEnd,tempdt,MyTextColor,MyBkgndColor,MyFont,foTempBrush,DTVC AS LONG
   LOCAL rowcolstr,mycell AS STRING
   LOCAL MLGStartTop,MLGStartLeft,MyJust,DrawFlag,MyWordWrap AS LONG  'DrawRect of Print File Cell
   LOCAL MySolidLine,MySolidLine2,MySolidLine3,hollowbrush,SDC AS DWORD
   LOCAL lb AS logbrush
   LOCAL Cellborder AS BYTE
   LOCAL DrawRect,wRect AS RECT

   MySolidLine=CreatePen(%PS_SOLID,1,RGB(255,0,0)) 'For Test Line
   SelectObject MyhDC, MySolidLine
   hollowbrush = GetStockObject(%HOLLOW_BRUSH)
   SelectObject MyhDC, hollowbrush

   OldTA=GetTextAlign (MyhDC)
   SetTextAlign MyhDC,%TA_LEFT OR %TA_NOUPDATECP OR %TA_TOP


      IF TotGRect.nTop > 0 OR TotGRectRR.nTop > 0 OR TotGRectRC.nTop > 0 THEN
         FOR WhichObject = 1 TO 16
          IF  gMyObjects(WhichObject).WhichObject > 0 THEN

           DrawRect.nLeft = (TotGRect.nLeft + gMyObjects(WhichObject).OffSetx) * xscale
           DrawRect.nTop =  (TotGRect.nTop + gMyObjects(WhichObject).Offsety)  * yscale
           DrawRect.Right =  DrawRect.nLeft + (gMyObjects(WhichObject).DrawRect.nRight) * xscale
           DrawRect.Bottom = DrawRect.nTop + (gMyObjects(WhichObject).DrawRect.nBottom) * yscale
           SDC = SaveDC(MyHDC)
           MyRectRgn= CreateRectRgn(DrawRect.nLeft, DrawRect.nTop, DrawRect.nRight, DrawRect.nBottom)
           SelectClipRgn MyhDC, MyRectRgn

           SelectObject MyhDC, gMLGFonts(gMyObjects(WhichObject).CellFont,whichfont)
           SetTextColor MyhDC, gMyObjects(WhichObject).TextCellColor

           tempdt = gMyObjects(WhichObject).CellStyle
           IF gMyObjects(WhichObject).CellJust = 3 THEN 'Wordwrap
               tempdt = %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_WORDBREAK
             ELSE 'No Wordwrap
               tempdt = tempdt OR %DT_EDITCONTROL OR %DT_NOPREFIX OR %DT_SINGLELINE
           END IF

           'make a brush
           lb.lbstyle=%BS_SOLID
           lb.lbcolor=gMyObjects(WhichObject).BkgGndCellColor
           foTempBrush=CreateBrushIndirect(lb)
           FillRect MyhDC,DrawRect,foTempBrush
           SetBkColor MyhDC, gMyObjects(WhichObject).BkgGndCellColor
           DeleteObject foTempBrush

           str = TRIM$(gMyObjects(WhichObject).PrintStr)
           IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),DrawRect, tempdt

           RestoreDC(MyhDC, SDC)
           DeleteObject(MyRectRgn)

           IF TotGRectRR.nTop > 0 THEN
             EXIT IF
             SDC = SaveDC(MyHDC)
             MyRectRgn= CreateRectRgn(TotGRectRR.nLeft, TotGRectRR.nTop, TotGRectRR.nRight, TotGRectRR.nBottom)
             SelectClipRgn MyhDC, MyRectRgn

             DrawRect.nLeft = (TotGRect.nLeft + gMyObjects(WhichObject).OffSetx) * xscale
             DrawRect.nTop =  (TotGRect.nTop + gMyObjects(WhichObject).Offsety)  * yscale
             DrawRect.Right =  DrawRect.nLeft + (gMyObjects(WhichObject).DrawRect.nRight) * xscale
             DrawRect.Bottom = DrawRect.nTop + (gMyObjects(WhichObject).DrawRect.nBottom) * yscale

             'make a brush
             lb.lbstyle=%BS_SOLID
             lb.lbcolor=gMyObjects(WhichObject).BkgGndCellColor
             foTempBrush=CreateBrushIndirect(lb)
             FillRect MyhDC,DrawRect,foTempBrush
             SetBkColor MyhDC, gMyObjects(WhichObject).BkgGndCellColor
             DeleteObject foTempBrush

             str = TRIM$(gMyObjects(WhichObject).PrintStr)
             IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),DrawRect, tempdt

             RestoreDC(MyhDC, SDC)
             DeleteObject(MyRectRgn)
           END IF

           IF TotGRectRC.nTop > 0 THEN
             EXIT IF
             SDC = SaveDC(MyHDC)
             MyRectRgn = CreateRectRgn(TotGRectRC.nLeft, TotGRectRC.nTop, TotGRectRC.nRight, TotGRectRC.nBottom)
             SelectClipRgn MyhDC, MyRectRgn

             DrawRect.nLeft = (TotGRect.nLeft + gMyObjects(WhichObject).OffSetx) * xscale
             DrawRect.nTop =  (TotGRect.nTop + gMyObjects(WhichObject).Offsety)  * yscale
             DrawRect.Right =  DrawRect.nLeft + (gMyObjects(WhichObject).DrawRect.nRight) * xscale
             DrawRect.Bottom = DrawRect.nTop + (gMyObjects(WhichObject).DrawRect.nBottom) * yscale

             'make a brush
             lb.lbstyle=%BS_SOLID
             lb.lbcolor=gMyObjects(WhichObject).BkgGndCellColor
             foTempBrush=CreateBrushIndirect(lb)
             FillRect MyhDC,DrawRect,foTempBrush
             SetBkColor MyhDC, gMyObjects(WhichObject).BkgGndCellColor
             DeleteObject foTempBrush

             str = TRIM$(gMyObjects(WhichObject).PrintStr)
             IF LEN(str) > 0 THEN DrawText MyhDC,BYVAL STRPTR(str), LEN(str),DrawRect, tempdt

             RestoreDC(MyhDC, SDC)
             DeleteObject(MyRectRgn)
           END IF

          END IF
        NEXT WhichObject
      END IF



   SetBkColor MyhDC, %WHITE
   SetTextColor MyhDC, %BLACK
   DeleteObject MySolidLine
   DeleteObject hollowbrush
   SetTextAlign MyhDC,OldTA
END SUB

SUB PrintMarginOutline
   LOCAL x,y AS LONG
   GRAPHIC STYLE 4

   x = PPScreenX * PPScreenPPIx
   y = (PPDeadZoneTop + PPHeader + PPMarginTop)* PPScreenPPIy
   GRAPHIC LINE (0,y)-(x,y)     'top margin left-right line

   y = (PPDeadZoneTop + PPMarginTop)* PPScreenPPIy
   GRAPHIC LINE (0,y)-(x,y)     'footer, left-right line

 '  y = (PPDeadZoneTop)* PPScreenPPIy
 '  GRAPHIC LINE (0,y)-(x,y)     'top deadzone, left-right line


   y = (PPScreenY - PPDeadZoneBottom - PPFooter - PPMarginBottom)* PPScreenPPIy
   GRAPHIC LINE (0,y)-(x,y)     'bottom margin, left-right line

   y = (PPScreenY - PPDeadZoneBottom - PPMarginBottom)* PPScreenPPIy
   GRAPHIC LINE (0,y)-(x,y)     'bottom margin, left-right line


  ' y = (PPScreenY - PPDeadZoneBottom)* PPScreenPPIy
 '  GRAPHIC LINE (0,y)-(x,y)     'bottom deadzone, left-right line


   x = (PPDeadZoneLeft + PPMarginLeft) * PPScreenPPIx
   y = PPScreenY * PPScreenPPIy
   GRAPHIC LINE (x,0)-(x,y)      'left margin, top-bottom line

   x = (PPScreenX - PPDeadZoneRight - PPMarginRight) * PPScreenPPIx
   GRAPHIC LINE (x,0)-(x,y)      'right margin, top-bottom line

  ' x = (PPScreenX - PPDeadZoneRight) * PPScreenPPIx
  ' GRAPHIC LINE (x,0)-(x,y)      'right deadzone, top-bottom line

  ' x = (PPDeadZoneLeft) * PPScreenPPIx
  ' GRAPHIC LINE (x,0)-(x,y)      'left deadzone, top-bottom line
END SUB

SUB PrintHeader
  IF PPHeaderArg > 0 THEN
   'print header, if desired. can be more complicated than this, hence the SUB
   'must be outside the PPDeadZoneY area at bottom of page
   LOCAL x,y,w,h,i,j,xcont,ycont,wcont,hcont,wnew,hnew AS LONG, temp$
   GRAPHIC ATTACH hPPDialog, %IDC_PrintGraphicHidden
   CONTROL GET SIZE hPPDialog, %IDC_PrintGraphicHidden TO w,h

   'GRAPHIC FONT PPFontNameH, PPFontPointsH, PPFontStyleH
   GRAPHIC SET FONT hPPFontHeader

   temp$ = PPHeaderTextL
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF TRIM$(UCASE$(temp$)) = "[DATE]" THEN temp$ = gMyDate
   GRAPHIC TEXT SIZE temp$ TO i,j
   GRAPHIC SET POS ((PPDeadZoneLeft+PPMarginLeft)*PPScreenPPIx,(PPDeadZoneTop+PPMarginTop)*PPScreenPPIy)
   GRAPHIC PRINT temp$

   temp$ = PPHeaderTextC
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF TRIM$(UCASE$(temp$)) = "[DATE]" THEN temp$ = gMyDate
   GRAPHIC TEXT SIZE temp$ TO i,j
   GRAPHIC SET POS ((PPScreenX*PPScreenPPIx-i)/2,(PPDeadZoneTop+PPMarginTop)*PPScreenPPIy)
   GRAPHIC PRINT temp$


   temp$ = PPHeaderTextR
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF TRIM$(UCASE$(temp$)) = "[DATE]" THEN temp$ = gMyDate
   GRAPHIC TEXT SIZE temp$ TO i,j
   GRAPHIC SET POS (w-(PPDeadZoneRight+PPMarginRight)*PPScreenPPIx -i,(PPDeadZoneTop+PPMarginTop)*PPScreenPPIy)
   GRAPHIC PRINT temp$
 END IF
END SUB

SUB PrintFooter
 IF PPFooterArg > 0 THEN
   'print footer, if desired. can be more complicated than this, hence the SUB
   'must be outside the PPDeadZoneY area at top of page
   LOCAL x,y,w,h,i,j,xcont,ycont,wcont,hcont,wnew,hnew AS LONG, temp$
   GRAPHIC ATTACH hPPDialog, %IDC_PrintGraphicHidden
   CONTROL GET SIZE hPPDialog, %IDC_PrintGraphicHidden TO w,h

   GRAPHIC SET FONT hPPFontHeader

   temp$ = PPFooterTextL
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF UCASE$(temp$) = "[DATE]" THEN temp$ = gMyDate
   GRAPHIC TEXT SIZE temp$ TO i,j
   GRAPHIC SET POS ((PPDeadZoneLeft+PPMarginLeft)*PPScreenPPIx,h-(PPDeadZoneBottom+PPMarginBottom)*PPScreenPPIy-j)
   GRAPHIC PRINT temp$

   temp$ = PPFooterTextC
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF UCASE$(temp$) = "[DATE]" THEN temp$ = gMyDate
   GRAPHIC TEXT SIZE temp$ TO i,j
   GRAPHIC SET POS ((PPScreenX*PPScreenPPIx-i)/2,h-(PPDeadZoneBottom+PPMarginBottom)*PPScreenPPIy-j)
   GRAPHIC PRINT temp$

   temp$ = PPFooterTextR
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF UCASE$(temp$) = "[DATE]" THEN temp$ = gMyDate
   GRAPHIC TEXT SIZE temp$ TO i,j
   GRAPHIC SET POS (w-(PPDeadZoneRight+PPMarginRight)*PPScreenPPIx - i,h-(PPDeadZoneBottom+PPMarginBottom)*PPScreenPPIy-j)
   GRAPHIC PRINT temp$
 END IF
END SUB

SUB PrintToVisibleGraphic
   LOCAL whidden,hhidden,w,h AS LONG
   LOCAL x,y,wNew,hNew AS SINGLE

   DIALOG SEND hPPDialog, %WM_SetRedraw, 0,0    'turn off draw to prevent flickering
   GRAPHIC ATTACH hPPViewPort, %IDC_PrintGraphicVisible
   GRAPHIC COLOR %BLACK, %RGB_LIGHTGRAY : GRAPHIC CLEAR

   'get the size/location to which the image will be sized
   SELECT CASE PPZoom
      CASE 1  'display whole page sized to fit within the dialog
         ShowScrollBar hPPViewPort, %SB_BOTH, 0       'both not visible
         CONTROL GET CLIENT hPPViewPort, %IDC_PrintGraphicVisible TO w,h
         wNew = PPSmallImageX : hNew = PPSmallImageY
         x = (w-wNew)/2       : y = (h-hNew)/2
      CASE 2  'display page size to fit width of dialog
         ShowScrollBar hPPViewPort, %SB_VERT, 1       'vertical visible
         wNew = PPSmallImageX : hNew = PPSmallImageY
         x = 20               : y = 20
      CASE ELSE    'display page at UL postion of 20,20  '3-.25 4-.50 5-.75 6-1.0 7-2.0 8-4.0
         ShowScrollBar hPPViewPort, %SB_BOTH, 1       'both visible
         wNew = PPSmallImageX : hNew = PPSmallImageY
         x = (PPScrollSizeX - PPSmallImageX) / 2
         y = (PPScrollSizeY - PPSmallImageY) / 2
         IF (2*x + wNew) < w THEN x = (w-wNew)/2
         IF (2*y + hNew) < h THEN y = (h-hNew)/2
   END SELECT

   'draw shadow boxes
   GRAPHIC BOX (x+10,y+10)-(x+wNew+10,y+hNew+10), 0, %RGB_DIMGRAY, %RGB_DIMGRAY, 0
   GRAPHIC BOX (x-1,y-1)-(x+wNew,y+hNew), 0, %BLACK, %WHITE, 0

   'draw content directly from hidden graphic control
   CONTROL GET SIZE hPPDialog, %IDC_PrintGraphicHidden TO whidden,hhidden
   GRAPHIC STRETCH hPPDialog, %IDC_PrintGraphicHidden, (0,0)-(whidden-1,hhidden-1) TO (x,y)-(x+wNew-1,y+hNew-1)

   'put the page number on the dialog
   DIALOG SET TEXT hPPDialog, "Print Preview" + SPACE$(10) + STR$(PPcurrentPage) + " of " + STR$(PPMaxPages) + " Page(s)" + SPACE$(10) + XPRINT$

   DIALOG SEND hPPDialog, %WM_SetRedraw, 1,0
   DIALOG REDRAW hPPDialog
   GRAPHIC REDRAW
END SUB

SUB PrintProperties
   'popup MsgBox with current Print Preview parameters
   LOCAL temp, fmt AS STRING
   fmt = "0.00"
   temp = "PPScreenX " + STR$(PPScreenX)
   temp = temp + $CRLF + "PPScreenY " + FORMAT$(PPScreenY,fmt$)
   temp = temp + $CRLF
   temp = temp + $CRLF + "PPMarginLeft " + FORMAT$(PPMarginLeft)
   temp = temp + $CRLF + "PPMarginRight " + FORMAT$(PPMarginRight)
   temp = temp + $CRLF + "PPMarginTop " + FORMAT$(PPMarginTop)
   temp = temp + $CRLF + "PPMarginBottom " + FORMAT$(PPMarginBottom)
   temp = temp + $CRLF
   temp = temp + $CRLF + "PPDeadZoneLeft " + FORMAT$(PPDeadZoneLeft,fmt$)
   temp = temp + $CRLF + "PPDeadZoneTop " + FORMAT$(PPDeadZoneTop,fmt$)
   temp = temp + $CRLF + "PPDeadZoneRight " + FORMAT$(PPDeadZoneRight,fmt$)
   temp = temp + $CRLF + "PPDeadZoneBottom " + FORMAT$(PPDeadZoneBottom,fmt$)
   temp = temp + $CRLF
   temp = temp + $CRLF + "PPFooter " + FORMAT$(PPFooter,fmt$)
   temp = temp + $CRLF + "PPHeader " + FORMAT$(PPHeader,fmt$)
   temp = temp + $CRLF
   temp = temp + $CRLF + "PPScreenPPIx " + STR$(PPScreenPPIx)
   temp = temp + $CRLF + "PPScreenPPIy " + STR$(PPScreenPPIy)
   temp = temp + $CRLF + "PPPrinterPPIx " + STR$(PPPrinterPPIx)
   temp = temp + $CRLF + "PPPrinterPPIy " + STR$(PPPrinterPPIy)
   temp = temp + $CRLF
   temp = temp + $CRLF + "PPMaxPages " + STR$(PPMaxPages)
   temp = temp + $CRLF + "PPCurrentPage " + STR$(PPCurrentPage)
   temp = temp + $CRLF + "PPOrientation " + STR$(PPOrientation)
   temp = temp + $CRLF + "PPLinesPerPage " + STR$(PPLinesPerPage)
   temp = temp + $CRLF + "PPMaxWidth " + FORMAT$(PPMaxWidth,fmt$)
   temp = temp + $CRLF
   temp = temp + $CRLF + "PPSmallImageX" + STR$(PPSmallImageX)
   temp = temp + $CRLF + "PPSmallImageY" + STR$(PPSmallImageY)
   temp = temp + $CRLF + "PPScrollSizeX" + STR$(PPScrollSizeX)
   temp = temp + $CRLF + "PPScrollSizeY" + STR$(PPScrollSizeY)
   MSGBOX temp, %MB_OK + %MB_TASKMODAL, "Print Preview Properties"
END SUB

SUB PrintPageSetup
   LOCAL STYLE AS LONG
   LOCAL convert AS SINGLE
   LOCAL unitsstr AS STRING


  DIM MyPapers(2) AS STRING
  DIM MyTrays(2) AS STRING

  MyPapers(0) = "One" :  MyPapers(1) = "Two" :  MyPapers(2) = "Three"
  MyTrays(0) = "One" :  MyTrays(1) = "Two" :  MyTrays(2) = "Three"



    IF gMarginsMM = 0 THEN
          convert = 1.000   ' 1000
          unitsstr = "(inches)"
        ELSE
          unitsstr = "(millimeters)"
          convert = 0.03937   ' 2540
    END IF

   DIALOG NEW PIXELS, hPPDialog, "Page Setup",100,100,300,260, %WS_CAPTION TO hPPPageSetupDlg
  ' DIALOG SET ICON hPPPageSetupDlg, "props"
   STYLE = %WS_CHILD OR %WS_VISIBLE OR %ES_MULTILINE OR %WS_VSCROLL _
      OR %ES_AUTOVSCROLL OR %ES_WANTRETURN OR %WS_TABSTOP OR %WS_BORDER

   CONTROL ADD LABEL, hPPPageSetupDlg, %IDC_PrintSettingsOrientation, "Orientation",   10, 10, 60, 20
   CONTROL ADD LABEL, hPPPageSetupDlg, %IDC_PrintSettingsMargins, "Margins " & unitsstr,   155, 10, 130, 20

   CONTROL ADD TEXTBOX, hPPPageSetupDlg, %IDC_PrintSettingsMT, FORMAT$(gPPMT/convert,"0.00"), 180, 48, 40, 20, %ES_CENTER OR %WS_TABSTOP OR %WS_BORDER, %WS_EX_CLIENTEDGE
   CONTROL ADD TEXTBOX, hPPPageSetupDlg, %IDC_PrintSettingsML, FORMAT$(gPPML/convert,"0.00"), 145, 68, 40, 20, %ES_CENTER OR %WS_TABSTOP OR %WS_BORDER, %WS_EX_CLIENTEDGE
   CONTROL ADD TEXTBOX, hPPPageSetupDlg, %IDC_PrintSettingsMR, FORMAT$(gPPMR/convert,"0.00"), 215, 68, 40, 20, %ES_CENTER OR %WS_TABSTOP OR %WS_BORDER, %WS_EX_CLIENTEDGE
   CONTROL ADD TEXTBOX, hPPPageSetupDlg, %IDC_PrintSettingsMB, FORMAT$(gPPMB/convert,"0.00"), 180, 90, 40, 20, %ES_CENTER OR %WS_TABSTOP OR %WS_BORDER, %WS_EX_CLIENTEDGE

   CONTROL ADD LABEL, hPPPageSetupDlg, %IDC_PrintSettingsMTL, "Top",    188,  30, 40, 17
   CONTROL ADD LABEL, hPPPageSetupDlg, %IDC_PrintSettingsMLL, "Left",   120,  70, 25, 20
   CONTROL ADD LABEL, hPPPageSetupDlg, %IDC_PrintSettingsMRL, "Right",  260,  70, 40, 20
   CONTROL ADD LABEL, hPPPageSetupDlg, %IDC_PrintSettingsMBL, "Bottom", 183,  110, 40, 20

   CONTROL ADD BUTTON, hPPPageSetupDlg, %IDC_PrintSettingsOK,"Ok", 90,230,60,20
   CONTROL ADD BUTTON, hPPPageSetupDlg, %IDC_PrintSettingsApply,"Apply", 160,230,60,20
   CONTROL ADD BUTTON, hPPPageSetupDlg, %IDC_PrintSettingsCancel,"Cancel", 230,230,60,20

   CONTROL ADD OPTION, hPPPageSetupDlg, %IDC_PrintSettingsPortrait, "Portrait",  15, 30, 60,20
   CONTROL ADD OPTION, hPPPageSetupDlg, %IDC_PrintSettingsLandscape, "Landscape", 15, 50, 75, 20
   'gPrintVertCentering = 1
   'gPrintHorzCentering = 1
   CONTROL ADD CHECKBOX, hPPPageSetupDlg, %IDC_PrintSettingsVCenter, "Vert Center",15, 90, 120, 20
   CONTROL ADD CHECKBOX, hPPPageSetupDlg, %IDC_PrintSettingsHCenter, "Horz Center", 15, 110, 120, 20
   CONTROL ADD CHECKBOX, hPPPageSetupDlg, %IDC_PrintSettingsGridlines, "No Gridlines", 15, 70, 90, 20

   CONTROL ADD BUTTON, hPPPageSetupDlg, %IDC_PrintSettingsPrintDlg," Change Printer ...", 15,165,100,20
   CONTROL ADD COMBOBOX, hPPPageSetupDlg, %IDC_PrintSettingsPaper, ,170, 150, 120, 80,%CBS_DROPDOWN OR %WS_VSCROLL
   CONTROL ADD COMBOBOX, hPPPageSetupDlg, %IDC_PrintSettingsTray, , 170, 180, 120, 80,%CBS_DROPDOWN OR %WS_VSCROLL
   CONTROL ADD LABEL, hPPPageSetupDlg, -1, "Paper", 125,  152, 40, 20
   CONTROL ADD LABEL, hPPPageSetupDlg, -1, "Tray", 125,  182, 40, 20
   CONTROL ADD FRAME, hPPPageSetupDlg, -1, "Change Printer", 5, 135, 290, 75

   DIALOG SHOW MODAL hPPPageSetupDlg CALL SetupDlgProc
   SetMenusAndToolbarButtons
END SUB

CALLBACK FUNCTION SetupDlgProc() AS LONG
   LOCAL i,iResult,x,y,myflag AS LONG
   LOCAL s,ss AS STRING
   LOCAL convert AS SINGLE

   STATIC RestorePPMT,RestorePPML,RestorePPMB,RestorePPMR AS SINGLE
   STATIC RestoreOrient,RestoreP,RestoreT,RestoreCV,RestoreCH,RestoreCopies,PT,RestoreGridlines AS LONG
   STATIC RestorePrinter AS STRING



    IF gMarginsMM = 0 THEN
          convert = 1.000   ' 1000
        ELSE
          convert = 0.03937   ' 2540
    END IF

   SELECT CASE CB.MSG
      CASE %WM_INITDIALOG

         FOR i = %IDC_PrintSettingsMT TO %IDC_PrintSettingsMargins
            CONTROL SET FONT hPPPageSetupDlg, i, hPPcFont
         NEXT i
         CONTROL SET TEXT hPPPageSetupDlg, %IDC_PrintSettingsMT, TRIM$(FORMAT$(gPPMT/convert,"0.00"))
         CONTROL SET TEXT hPPPageSetupDlg, %IDC_PrintSettingsML, TRIM$(FORMAT$(gPPML/convert,"0.00"))
         CONTROL SET TEXT hPPPageSetupDlg, %IDC_PrintSettingsMR, TRIM$(FORMAT$(gPPMR/convert,"0.00"))
         CONTROL SET TEXT hPPPageSetupDlg, %IDC_PrintSettingsMB, TRIM$(FORMAT$(gPPMB/convert,"0.00"))
         IF PPOrientation = 1 THEN
             CONTROL SET CHECK hPPPageSetupDlg, %IDC_PrintSettingsPortrait, 1
            ELSE
             CONTROL SET CHECK hPPPageSetupDlg, %IDC_PrintSettingsLandscape, 1
         END IF

         CONTROL DISABLE hPPPageSetupDlg,%IDC_PrintSettingsPaper
         CONTROL DISABLE hPPPageSetupDlg,%IDC_PrintSettingsTray

          IF gPrintVertCentering = 1 THEN CONTROL SET CHECK hPPPageSetupDlg, %IDC_PrintSettingsVCenter,1
          IF gPrintHorzCentering = 1 THEN CONTROL SET CHECK hPPPageSetupDlg, %IDC_PrintSettingsHCenter,1
          IF gGridlines = 1 THEN CONTROL SET CHECK hPPPageSetupDlg, %IDC_PrintSettingsGridlines,1
          '---------------save setting--------------------
          RestoreCH = gPrintHorzCentering
          RestoreCV = gPrintVertCentering
          RestorePPMT = gPPMT
          RestorePPML = gPPML
          RestorePPMB = gPPMB
          RestorePPMR = gPPMR
          RestoreCopies = gPPCopies
          RestoreP = gPaper
          RestoreT = gTray
          RestorePrinter = PPPrinterName
          RestoreOrient = PPOrientation
          RestoreGridlines = gGridlines
          PT = 0

      CASE %WM_COMMAND
         SELECT CASE CB.CTL
            CASE %IDC_PrintSettingsOK     : PrintSaveSetup(PT) : PrintRefresh : SetMenusAndtoolbarButtons : DIALOG END hPPPageSetupDlg
            CASE %IDC_PrintSettingsApply  : PrintSaveSetup(PT) : PrintRefresh : SetMenusAndToolbarButtons
            CASE %IDC_PrintSettingsCancel
                'put back the way it started
                 gPrintHorzCentering = RestoreCH
                 gPrintVertCentering = RestoreCV
                 gPPMT = RestorePPMT
                 gPPML = RestorePPML
                 gPPMB =  RestorePPMB
                 gPPMR = RestorePPMR
                 gPPCopies = RestoreCopies
                 gPaper= RestoreP
                 gTray = RestoreT
                 PPPrinterName = RestorePrinter
                 PPOrientation = RestoreOrient
                 PrintSaveSetup(PT) : PrintRefresh : SetMenusAndToolbarButtons
                 DIALOG END hPPPageSetupDlg

            CASE %IDC_PrintSettingsPrintDlg

              IF PPPrinterSelect = 0 THEN
                  PPPrinterSelect = 1
                  XPRINT ATTACH CHOOSE
                  IF LEN(XPRINT$)= 0 THEN
                      XPRINT ATTACH PPPrinterName
                   ELSE
                      PT = 1  'Save the combo boxes in PrintSaveSetup
                     'Get Paper and Tray results which should be the defaults
                     'We possibly have a new printer
                     XPRINT GET TRAY TO gTray
                     XPRINT GET PAPER TO gPaper
                     'gMyPapers,gMyTrays
                     XPRINT GET TRAYS TO gMyTrays
                     XPRINT GET PAPERS TO gMyPapers

                     XPRINT GET COPIES TO iResult  '<--- MLG disable the orientation reset
                     IF iResult < 1 THEN iResult = 1
                     gPPCopies =  iResult
                     CONTROL SET TEXT hPPDialog, %IDC_PrintNumCopies , STR$(gPPCopies)

                     CONTROL ENABLE hPPPageSetupDlg,%IDC_PrintSettingsPaper
                     CONTROL ENABLE hPPPageSetupDlg,%IDC_PrintSettingsTray

                     ss=""
                     myflag = 0
                     COMBOBOX RESET hPPPageSetupDlg, %IDC_PrintSettingsTray
                     y = 0
                     FOR x =1 TO PARSECOUNT(gMyTrays)
                      ss= PARSE$(gMyTrays,x) : IF VAL(ss) = gTray THEN myflag = 1
                      IF (x MOD 2) = 0 THEN
                          INCR y
                          COMBOBOX ADD hPPPageSetupDlg, %IDC_PrintSettingsTray, ss
                          COMBOBOX SET USER hPPPageSetupDlg, %IDC_PrintSettingsTray, y, VAL(PARSE$(gMyTrays,x-1))
                          IF myflag = 1 THEN COMBOBOX SELECT hPPPageSetupDlg, %IDC_PrintSettingsTray, y : myflag = 0
                      END IF
                     NEXT

                     ss=""
                     myflag = 0
                     COMBOBOX RESET hPPPageSetupDlg, %IDC_PrintSettingsPaper
                     y = 0
                     FOR x =1 TO PARSECOUNT(gMyPapers)
                      ss= PARSE$(gMyPapers,x) : IF VAL(ss) = gPaper THEN myflag = 1
                      IF (x MOD 2) = 0 THEN
                          INCR y
                          COMBOBOX ADD hPPPageSetupDlg, %IDC_PrintSettingsPaper, ss
                          COMBOBOX SET USER hPPPageSetupDlg, %IDC_PrintSettingsPaper, y, VAL(PARSE$(gMyPapers,x-1))
                          IF myflag = 1 THEN COMBOBOX SELECT hPPPageSetupDlg, %IDC_PrintSettingsPaper, y : myflag = 0
                      END IF
                     NEXT

                  END IF
                  SetPrintPreviewProperties
                  SetMenusAndToolbarButtons  '<--- updates Toolbar with orientation selection
                  PPPrinterName = XPRINT$  '<--- get user selection of Printer Name
                  PrintRefresh     '<--- this gets the user selection of PPI and Margins (SetPrinterPreviewProperties)
                  PPPrinterSelect = 0
                  CONTROL SET FOCUS hPPDialog, %IDC_PrintMinPage
               END IF

         END SELECT
      CASE %WM_DESTROY
   END SELECT
END FUNCTION

SUB PrintSaveSetup(PaperandTray AS LONG)
   LOCAL temp AS STRING
   LOCAL orient AS LONG
   LOCAL vcheck, hcheck,myflag,x,y AS LONG
   LOCAL convert AS SINGLE
   LOCAL s,ss AS STRING


    IF gMarginsMM = 0 THEN
          convert = 1.000   ' 1000
        ELSE
          convert = 0.03937   ' 2540
    END IF

   CONTROL GET CHECK hPPPageSetupDlg, %IDC_PrintSettingsPortrait TO orient
   IF orient = 1 THEN  PPOrientation = 1 ELSE PPOrientation = 2
   IF PPOrientation = 1 THEN XPRINT SET ORIENTATION 1 ELSE XPRINT SET ORIENTATION 2

   CONTROL GET TEXT hPPPageSetupDlg, %IDC_PrintSettingsMT TO temp : gPPMT = VAL(temp) * convert
   CONTROL GET TEXT hPPPageSetupDlg, %IDC_PrintSettingsML TO temp : gPPML = VAL(temp) * convert
   CONTROL GET TEXT hPPPageSetupDlg, %IDC_PrintSettingsMR TO temp : gPPMR = VAL(temp) * convert
   CONTROL GET TEXT hPPPageSetupDlg, %IDC_PrintSettingsMB TO temp : gPPMB = VAL(temp) * convert

   CONTROL GET CHECK hPPPageSetupDlg, %IDC_PrintSettingsVCenter TO gPrintVertCentering
   CONTROL GET CHECK hPPPageSetupDlg, %IDC_PrintSettingsHCenter TO gPrintHorzCentering
   CONTROL GET CHECK hPPPageSetupDlg, %IDC_PrintSettingsGridlines TO gGridlines

   IF PaperandTray <> 0 THEN
       COMBOBOX GET SELECT hPPPageSetupDlg, %IDC_PrintSettingsTray TO x
       COMBOBOX GET USER hPPPageSetupDlg, %IDC_PrintSettingsTray, x TO gTray

       COMBOBOX GET SELECT hPPPageSetupDlg, %IDC_PrintSettingsPaper TO x
       COMBOBOX GET USER hPPPageSetupDlg, %IDC_PrintSettingsPaper, x TO gPaper
   END IF
   XPRINT SET PAPER gPaper
   XPRINT SET TRAY gTray
   SetPrintPreviewProperties
   SetMenusAndToolbarButtons  '<--- updates Toolbar with orientation selection
   PrintRefresh
END SUB

FUNCTION SetToolTips(cID AS LONG) AS STRING
   SELECT CASE cID          'or this:   @P.hdr.idFrom
      CASE %IDT_PrinterSelect         : FUNCTION = "Select Printer"
      CASE %IDT_PrintSettings         : FUNCTION = "Settings Dialog"
      CASE %IDT_PrintPrior            : FUNCTION = "Show Previous Page"
      CASE %IDT_PrintNext             : FUNCTION = "Show Next Page"
      CASE %IDT_PrintAll              : FUNCTION = "Print All Pages"
      CASE %IDT_PrintPage             : FUNCTION = "Print Current Page"
      CASE %IDT_PrintRange            : FUNCTION = "Print Page Range"
      CASE %IDT_PrintOrientation      : FUNCTION = "Cycle Between Portrait and Landscape Orientation"
      CASE %IDT_PrintShowMargins      : FUNCTION = "Show Page Margins"
      CASE %IDT_PrintZoom             : FUNCTION = "Cycle Through All Zoom Settings"
      CASE %IDT_PrintHeader           : FUNCTION = "Show Header"
      CASE %IDT_PrintFooter           : FUNCTION = "Show Footer"
      CASE %IDT_PrintFooter           : FUNCTION = "Close Print Preview Dialog"
   END SELECT
END FUNCTION

SUB ScrollBarInitialize
   LOCAL si AS ScrollInfo, wClient,hClient AS LONG
   DIALOG GET CLIENT hPPViewPort TO wClient, hClient                      'w/o scrollbars (called from WM_InitDialog)
   wClient -= GetSystemMetrics(%SM_CXVSCROLL)                             'less vertical scrollbar
   hClient -= GetSystemMetrics(%SM_CXHSCROLL)                             'less horizontal scrollbar
   si.cbSize=LEN(si) : si.fMask=%SIF_ALL                                  'preset values before using SetScrollInfo
   si.nMax=PPhMax : si.nPage=hClient : SetScrollInfo hPPViewPort, %SB_VERT, si, 1  'set Vert scrollbar properties
   si.nMax=PPwMax : si.nPage=wClient : SetScrollInfo hPPViewPort, %SB_HORZ, si, 1  'set Horz scrollbar properties
END SUB

SUB ScrollBarRespond(HorzVert AS LONG, wParam AS LONG)
   LOCAL si AS ScrollInfo, oldPos AS LONG
   si.cbSize=SIZEOF(si) : si.fMask=%SIF_ALL
   GetScrollInfo hPPViewPort, HorzVert, si
   oldPos=si.nPos
   SELECT CASE LO(WORD, wParam)
      CASE %SB_LINELEFT, %SB_LINEUP    :  si.nPos -= IIF(HorzVert,PPhs,PPvs)
      CASE %SB_PAGELEFT, %SB_PAGEUP    :  si.nPos -= si.nPage
      CASE %SB_LINERIGHT, %SB_LINEDOWN :  si.nPos += IIF(HorzVert,PPhs,PPvs)
      CASE %SB_PAGERIGHT, %SB_PAGEDOWN :  si.nPos += si.nPage
      CASE %SB_THUMBTRACK              :  si.nPos=HI(WORD, wParam)
      CASE ELSE                        :  EXIT SUB
   END SELECT
   si.nPos=MAX&(si.nMin, MIN&(si.nPos, si.nMax-si.nPage))
   SetScrollInfo hPPViewPort,HorzVert,si,1
   IF HorzVert = %SB_HORZ THEN ScrollWindow hPPViewPort, oldPos-si.nPos,0 , BYVAL %NULL, BYVAL %NULL
   IF HorzVert = %SB_VERT THEN ScrollWindow hPPViewPort, 0, oldPos-si.nPos, BYVAL %NULL, BYVAL %NULL
END SUB

SUB SendToPrinter(Flag AS LONG, BYVAL MinPge AS LONG, BYVAL MaxPge AS LONG)
   '0=all  1=current 2=range
   LOCAL MinPage, MaxPage, counter AS LONG
   LOCAL temp AS STRING

'   XPrint Close
'   If Len(XPrint$) = 0 Then XPrint Attach Default Else XPrint Attach PPPrinterName
'   If PPOrientation Then XPrint Set Orientation 1 Else XPrint Set Orientation 2

  ' gPaper,gTray
  IF gPaper <> 0 THEN XPRINT SET PAPER gPaper
  IF gTray <> 0 THEN XPRINT SET TRAY gTray


   SELECT CASE Flag
      CASE 0   'all pages
        FOR counter = 1 TO gPPCopies
             FOR PPCurrentPage = 1 TO PPMaxPages
                PrintToPrinter
             NEXT PPCurrentPage
        NEXT counter
      CASE 1   'current page only
         FOR counter = 1 TO gPPCopies
           PrintToPrinter
         NEXT counter
      CASE 2   'range
         CONTROL GET TEXT hPPDialog, %IDC_PrintMinPage TO temp : MinPage = VAL(temp)
         CONTROL GET TEXT hPPDialog, %IDC_PrintMaxPage TO temp : MaxPage = VAL(temp)
         IF MinPge THEN MinPage = MinPge  'for direct print through
         IF MaxPge THEN MaxPage = MaxPge  'for direct print through
         IF MinPage < 1 THEN MinPage = 1
         IF MinPage > PPMaxPages THEN MinPage = PPMaxPages
         IF MaxPage < MinPage THEN MaxPage = MinPage
         IF MaxPage > PPMaxPages THEN MaxPage = PPMaxPages
         FOR counter = 1 TO gPPCopies
             FOR PPCurrentPage = MinPage TO MaxPage
                PrintToPrinter
             NEXT PPCurrentPage
         NEXT counter
   END SELECT
   XPRINT CLOSE   'print paper
END SUB

SUB PrintToPrinter
   'confirm current page exists
   IF PPCurrentPage > PPMaxPages THEN PPCurrentPage = 1

   'display page number being printed
   CONTROL SET TEXT hPPDialog, %IDC_PrintPageLabel, STR$(PPCurrentPage)

   IF PPShowHeader THEN PrintHeaderToPrinter          'print header
  ' PrintTextToPrinter                                 'print text
   MLG_PrintGrid 1
   IF PPShowFooter THEN PrintFooterToPrinter          'print footer
   IF PPShowMargins THEN PrintMarginOutlineToPrinter  'print outline
   XPRINT FORMFEED
END SUB

SUB PrintMarginOutLineToPrinter
   LOCAL x,y AS LONG


    'Not used in MLG
      EXIT SUB


   XPRINT WIDTH 2
   XPRINT STYLE 4



   'Left to Right lines:
   x = PPPaperX * PPPrinterPPIx

  ' MSGBOX STR$(PPPaperX)  + STR$(PPPaperY)

   y = 0
   XPRINT LINE (0,y)-(x,y)     'top margin left-right line
   y = PPMarginTop * PPPrinterPPIy
   XPRINT LINE (0,y)-(x,y)     'top margin left-right line
   y = (PPMarginTop + PPHeader) * PPPrinterPPIy
   XPRINT LINE (0,y)-(x,y)     'top margin left-right line

   y = (PPPaperY - PPFooter - PPMarginBottom) * PPPrinterPPIy
   XPRINT LINE (0,y)-(x,y)     'top margin left-right line
   y = (PPPaperY - PPMarginBottom) * PPPrinterPPIy
   XPRINT LINE (0,y)-(x,y)     'top margin left-right line
   y = PPPapery * PPPrinterPPIy
   XPRINT LINE (0,y)-(x,y)     'top margin left-right line

   'Top to bottom lines
   y = PPPaperY * PPPrinterPPIy
   x = 0
   XPRINT LINE (x,0)-(x,y)      'left margin, top-bottom line

   x = PPMarginLeft * PPPrinterPPIx
   XPRINT LINE (x,0)-(x,y)      'left margin, top-bottom line

   x = (PPPaperX - PPMarginRight) * PPPrinterPPIx
   XPRINT LINE (x,0)-(x,y)      'right margin, top-bottom line

   x = PPPaperX * PPPrinterPPIx
   XPRINT LINE (x,0)-(x,y)      'right margin, top-bottom line
END SUB

SUB PrintFooterToPrinter
   'print footer to printer, if desired. can be more complicated than this, hence the SUB
   'must be outside the PPDeadZoneY area at top of page
 IF PPFooterArg > 0 THEN
   LOCAL x,y,w,h,i,j AS LONG, RatioX, RatioY AS SINGLE, temp$
   LOCAL xcont,ycont,wcont,hcont,wnew,hnew AS LONG

   w = PPPaperX * PPPrinterPPIx
   h = PPPaperY * PPPrinterPPIy

   XPRINT SET FONT hPPFontHeader

   'print footer text (left)
   temp$ = PPFooterTextL
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF UCASE$(temp$) = "[DATE]" THEN temp$ = gMyDate
   XPRINT TEXT SIZE temp$ TO i,j
   XPRINT SET POS (PPMarginLeft*PPPrinterPPIx,h-j-(PPMarginBottom * PPPrinterPPIy)) '-(PPMarginBottom* PPPrinterPPIy)
   XPRINT temp$

   'print footer text (center)
   temp$ = PPFooterTextC
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF UCASE$(temp$) = "[DATE]" THEN temp$ = gMyDate
   XPRINT TEXT SIZE temp$ TO i,j
   XPRINT SET POS ((PPPaperX*PPPrinterPPIx-i)/2,h-j-(PPMarginBottom * PPPrinterPPIy))
   XPRINT temp$

   'print footer text (right)
   temp$ = PPFooterTextR
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF UCASE$(temp$) = "[DATE]" THEN temp$ = gMyDate
   XPRINT TEXT SIZE temp$ TO i,j
   XPRINT SET POS (w-i-PPMarginRight*PPPrinterPPIx,h-j-(PPMarginBottom * PPPrinterPPIy))
   XPRINT temp$
 END IF
END SUB

SUB PrintHeaderToPrinter
   'print header to printer, if desired. can be more complicated than this, hence the SUB
   'must be outside the PPDeadZoneY area at bottom of page
 IF PPHeaderArg > 0 THEN

   LOCAL x,y,w,h,i,j AS LONG, temp$
   LOCAL xcont,ycont,wcont,hcont,wnew,hnew AS LONG

   w = PPPaperX * PPPrinterPPIx
   h = PPPaperY * PPPrinterPPIy

   XPRINT SET FONT hPPFontHeader

   'print header text (left)
   temp$ = PPHeaderTextL
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF TRIM$(UCASE$(temp$)) = "[DATE]" THEN temp$ = gMyDate
   XPRINT TEXT SIZE temp$ TO i,j
   XPRINT SET POS ((PPMarginLeft)*PPPrinterPPIx,0 + (PPMarginTop * PPPrinterPPIy))
   XPRINT PRINT temp$

   'print header text (center)
   temp$ = PPHeaderTextC
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF TRIM$(UCASE$(temp$)) = "[DATE]" THEN temp$ = gMyDate
   XPRINT TEXT SIZE temp$ TO i,j
   XPRINT SET POS ((PPPaperX*PPPrinterPPIx-i)/2,0 + (PPMarginTop * PPPrinterPPIy))
   XPRINT PRINT temp$

   'print header text (right)
   temp$ = PPHeaderTextR
   IF UCASE$(temp$) = "[PAGE]" THEN temp$ = "Page" + STR$(PPCurrentPage) + " of " + TRIM$(STR$(PPMaxPages))
   IF UCASE$(temp$) = "[TIME]" THEN temp$ = gMyTime
   IF TRIM$(UCASE$(temp$)) = "[DATE]" THEN temp$ = gMyDate
   XPRINT TEXT SIZE temp$ TO i,j
   XPRINT SET POS (w-i-PPMarginRight*PPPrinterPPIx,0 + (PPMarginTop * PPPrinterPPIy))
   XPRINT PRINT temp$

 END IF

END SUB

SUB PrintTextToPrinter
   'print only the lines for the specified page
   LOCAL FirstLine, LastLine, i, j  AS LONG
   XPRINT SET FONT hPPFontText
   CreatePrintContentPrinter
   XPRINT SET POS (0,PPPrinterPPIx * (PPMarginTop + PPHeader))
 '  FirstLine = (PPCurrentPage-1)*PPLinesPerPage     'zero based array
 '  LastLine = PPCurrentPage * PPLinesPerPage - 1    'zero based array
 '  IF LastLine > UBOUND(PPPrintArray) THEN LastLine = UBOUND(PPPrintArray)
 '  j = PPPrinterPPIx*PPMarginLeft
 '  FOR i = FirstLine TO LastLine
 '     XPRINT SET POS STEP (j,0)
 '     XPRINT PRINT PPPrintArray(i)
 '  NEXT i
END SUB

SUB CreatePrintContentPrinter
   'this routine would be custom for every application
   'put text into array for printing
   LOCAL PPTempText AS STRING
  ' IF PPWordWrap THEN PPTempText = WordWrapPrinter(PPText, %True) ELSE PPTempText = PPText
   PPTempText = PPText
 '  REDIM PPPrintArray(PARSECOUNT(PPTempText, $CRLF)-1)
 '  PARSE PPTempText, PPPrintArray(), $CRLF
 '  PPMaxPages = (UBOUND(PPPrintArray)\PPLinesPerPage)
 '  IF UBOUND(PPPrintArray) MOD PPLinesPerPage THEN PPMaxPages = PPMaxPages + 1
END SUB

SUB CreateToolbar
   LOCAL hPPToolbar AS DWORD
   LOCAL counter AS LONG

   REDIM gToolbarIcon(13) AS DWORD


    GRAPHIC BITMAP LOAD "ppprint", 16, 16  TO gToolbarIcon(1)
    GRAPHIC BITMAP LOAD "ppyang", 16, 16  TO gToolbarIcon(2)
    GRAPHIC BITMAP LOAD "ppfirst", 16, 16  TO gToolbarIcon(3)
    GRAPHIC BITMAP LOAD "ppforward", 16, 16  TO gToolbarIcon(4)
    GRAPHIC BITMAP LOAD "ppback", 16, 16  TO gToolbarIcon(5)
    GRAPHIC BITMAP LOAD "pplast", 16, 16  TO gToolbarIcon(6)
    GRAPHIC BITMAP LOAD "ppzoom", 16, 16  TO gToolbarIcon(7)
    GRAPHIC BITMAP LOAD "ppabout", 16, 16  TO gToolbarIcon(8)
    GRAPHIC BITMAP LOAD "ppexit", 16, 16  TO gToolbarIcon(9)
    GRAPHIC BITMAP LOAD "pptext", 16, 16  TO gToolbarIcon(10)




    LOCAL PixelPtr AS LONG PTR
    LOCAL bmp$
    LOCAL xsize&,ysize&,mycolor&
    LOCAL MyhDC AS DWORD

    FOR counter = 1 TO 10
        GRAPHIC ATTACH gToolbarIcon(counter),0
        GRAPHIC GET BITS TO bmp$
        xsize& = CVL(bmp$,1)
        ysize& = CVL(bmp$,5)
        PixelPtr = STRPTR(bmp$) + 8
        MyColor& =  @PixelPtr
        FOR i& = 1 TO xsize& * ysize&
          IF @PixelPtr = MyColor& THEN @PixelPtr = BGR(%RGB_LIGHTGRAY)
          INCR PixelPtr
        NEXT
        GRAPHIC SET BITS bmp$
        'if Counter= 10 then
        '  GRAPHIC GET DC TO MyhDC
        '  gToolbarIcon(11)=MLG_MakeBitmapMask(MyhDC,xsize&, ysize&,%RGB_LIGHTGRAY)
        'end if

    NEXT counter




   IMAGELIST NEW BITMAP 16,16,24,9 TO PPImageList
   FOR counter = 1 TO 10
     IMAGELIST ADD BITMAP PPImageList, gToolbarIcon(counter)        '1
   NEXT counter

   REDIM PPZoomText(7)
   ARRAY ASSIGN PPZoomText() = "Page", "Width", "25%", "50%", "75%", "100%", "200%", "400%"

    CONTROL ADD TOOLBAR, hPPDialog, %IDC_PPToolbar,"", 0,0,0,0, %TBSTYLE_TOOLTIPS OR %TBSTYLE_FLAT OR %WS_CHILD OR %WS_CLIPSIBLINGS OR %TBSTYLE_TRANSPARENT
    CONTROL HANDLE hPPDIalog, %IDC_PPToolbar TO hPPToolbar


    'CONTROL SET COLOR hPPDialog, %IDC_PPToolbar, RGB(255,0,255), RGB(0,0,255)


    SendMessage hPPToolbar, %TB_SETEXTENDEDSTYLE, 0, %TBSTYLE_EX_DRAWDDARROWS

    TOOLBAR SET IMAGELIST hPPDialog, %IDC_PPToolbar, PPImageList, 0             'default imagelist

    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 8, %IDT_PrintAbout,  %TBSTYLE_BUTTON, "About"    'IDT_PrintAbout
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 2, %IDT_PrintSettings,  %TBSTYLE_BUTTON, "Settings"

    TOOLBAR ADD SEPARATOR hPPDialog, %IDC_PPToolbar, 5
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 3, %IDT_PrintFirst,  %TBSTYLE_BUTTON, "First"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 5, %IDT_PrintPrior,  %TBSTYLE_BUTTON, "Prior"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 0, %IDT_PrintBlankA,  %TBSTYLE_BUTTON, "Page"
    TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar,  BYCMD %IDT_PrintBlankA,%TBSTATE_DISABLED
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 4, %IDT_PrintNext,  %TBSTYLE_BUTTON, "Next"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 6, %IDT_PrintLast,  %TBSTYLE_BUTTON, "Last"

    TOOLBAR ADD SEPARATOR hPPDialog, %IDC_PPToolbar, 5


    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 1, %IDT_PrintRange,  %TBSTYLE_BUTTON, "Print"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 0, %IDT_PrintBlankB,  %TBSTYLE_BUTTON, "From     To     Copies  "
    TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar,  BYCMD %IDT_PrintBlankB,%TBSTATE_DISABLED

    TOOLBAR ADD SEPARATOR hPPDialog, %IDC_PPToolbar, 5

    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 7, %IDT_PrintZoom,  %TBSTYLE_BUTTON OR %TBSTYLE_DROPDOWN, PPZoomText(PPZoom-1)

    TOOLBAR ADD SEPARATOR hPPDialog, %IDC_PPToolbar, 5
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 10, %IDT_PrintOrientation,  %TBSTYLE_BUTTON, "Portrait"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 10, %IDT_PrintHeader,  %TBSTYLE_CHECK, "Header"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 10, %IDT_PrintFooter,  %TBSTYLE_CHECK, "Footer"
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 10, %IDT_PrintShowMargins,  %TBSTYLE_CHECK, "Margins"
    TOOLBAR ADD SEPARATOR hPPDialog, %IDC_PPToolbar, 5
    TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 9, %IDT_PrintClose,  %TBSTYLE_BUTTON, "Exit"

    MENU NEW POPUP TO hPopupPPZoom
    MENU ADD STRING, hPopupPPZoom, "Page", %IDM_PrintZoomPage, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "Width", %IDM_PrintZoomWidth, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "25%", %IDM_PrintZoom25, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "50%", %IDM_PrintZoom50, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "75%", %IDM_PrintZoom75, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "100%", %IDM_PrintZoom100, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "200%", %IDM_PrintZoom200, %MF_ENABLED
    MENU ADD STRING, hPopupPPZoom, "400%", %IDM_PrintZoom400, %MF_ENABLED

END SUB

SUB SetMenusAndToolbarButtons
   LOCAL i AS LONG
   'Toolbar Buttons
   IF PPOrientation = 1 THEN
      TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar, BYCMD %IDT_PrintOrientation, %TBSTATE_CHECKED OR %TBSTATE_ENABLED
     ELSE
      TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar, BYCMD %IDT_PrintOrientation, 0 OR %TBSTATE_ENABLED
   END IF
   TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar, BYCMD %IDT_PrintFooter, %TBSTATE_CHECKED * PPShowFooter OR %TBSTATE_ENABLED
   TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar, BYCMD %IDT_PrintHeader, %TBSTATE_CHECKED * PPShowHeader OR %TBSTATE_ENABLED
   TOOLBAR SET STATE hPPDialog, %IDC_PPToolbar, BYCMD %IDT_PrintShowMargins, %TBSTATE_CHECKED * PPSHowMargins OR %TBSTATE_ENABLED

   'Menus
   FOR i = %IDM_PrintZoomPage TO %IDM_PrintZoom400
      MENU SET STATE hPopupPPZoom, BYCMD i, %MFS_Enabled
   NEXT i
   MENU SET STATE hPopupPPZoom, BYCMD %IDM_PrintZoomPage+PPZoom-1, %MFS_Enabled OR %MFS_Checked
END SUB

SUB RebuildToolbar
   TOOLBAR DELETE BUTTON hPPDialog, %IDC_PPToolbar, 13
   TOOLBAR ADD BUTTON  hPPDialog, %IDC_PPToolbar, 8, %IDT_PrintZoom,  %TBSTYLE_BUTTON OR %TBSTYLE_DROPDOWN, PPZoomText(PPZoom-1) AT 13
END SUB

SUB BuildAcceleratorTable
   LOCAL c AS LONG, ac() AS ACCELAPI, hAccelerator AS DWORD  ' for keyboard accelator table values
   DIM ac(18)
   ac(c).fvirt = %FVIRTKEY              : ac(c).key   = %VK_F1     : ac(c).cmd   = %IDM_Help                  : INCR c
   ac(c).fvirt = %FVIRTKEY              : ac(c).key   = %VK_F9     : ac(c).cmd   = %IDM_PrintTest             : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_D      : ac(c).cmd   = %IDT_PrinterSelect         : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_F      : ac(c).cmd   = %IDT_PrintFooter           : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_H      : ac(c).cmd   = %IDT_PrintHeader           : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_K      : ac(c).cmd   = %IDT_PrintPrior            : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_M      : ac(c).cmd   = %IDT_PrintShowMargins      : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_N      : ac(c).cmd   = %IDT_PrintNext             : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_P      : ac(c).cmd   = %IDT_PrintPage             : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_R      : ac(c).cmd   = %IDT_PrintRange            : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_S      : ac(c).cmd   = %IDT_PrintSettings         : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_T      : ac(c).cmd   = %IDM_PrintProperties       : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_W      : ac(c).cmd   = %IDM_PrintZoom100          : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_X      : ac(c).cmd   = %IDT_PrintClose            : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_Z      : ac(c).cmd   = %IDT_PrintZoom             : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_HOME   : ac(c).cmd   = %IDM_PrintHome             : INCR c
   ac(c).fvirt = %FVIRTKEY OR %FCONTROL : ac(c).key   = %VK_END    : ac(c).cmd   = %IDM_PrintEnd              : INCR c
   ac(c).fvirt = %FVIRTKEY              : ac(c).key   = %VK_PRIOR  : ac(c).cmd   = %IDT_PrintNext             : INCR c
   ac(c).fvirt = %FVIRTKEY              : ac(c).key   = %VK_NEXT   : ac(c).cmd   = %IDT_PrintPrior            : INCR c
   ACCEL ATTACH hPPDialog, AC() TO hAccelerator
END SUB

FUNCTION PPNewProc(BYVAL hWnd AS LONG, BYVAL Msg AS LONG, BYVAL wParam AS LONG, BYVAL lParam AS LONG) AS LONG
   LOCAL x,y AS LONG
   SELECT CASE Msg
      CASE %WM_ContextMenu
         SetFocus hWnd
         x = LO(INTEGER,lParam) : y = HI(INTEGER, lParam)    'WM_ContextMenu returns xy coordinates of mouse
         TrackPopupMenu hPPPopupContext, %TPM_LEFTALIGN, x, y, 0, hPPDialog, BYVAL 0   'put context menu where mouse is
         FUNCTION = 0 : EXIT FUNCTION
   END SELECT
   FUNCTION = CallWindowProc(PPOldProc, hWnd, Msg, wParam, lParam)
END FUNCTION

SUB CreatePrintPopUpMenu
   MENU NEW POPUP TO hPPPopupContext
   MENU ADD STRING, hPPPopupContext, "Copy",   %IDM_PrintCopy,  %MF_ENABLED
   MENU ADD STRING, hPPPopupContext, "Cut",    %IDM_PrintCut,  %MF_ENABLED
   MENU ADD STRING, hPPPopupContext, "Paste",  %IDM_PrintPaste,  %MF_ENABLED
   MENU ADD STRING, hPPPopupContext, "Delete", %IDM_PrintDelete,  %MF_ENABLED
END SUB
