'
'    My Little Grid -- MLGDemo by James Klutho
'    Demo all the notifications and Cell types
'
#COMPILE EXE

#INCLUDE "WIN32API.INC" 'PB's win API declares include file
#INCLUDE "MLG.INC"

%IDC_MLGGRID1 = 101
%IDC_MLGLIST1 = 500

GLOBAL hGrid1 AS DWORD
GLOBAL hList1 AS DWORD
'--------------------------------------------------------------------
DECLARE CALLBACK FUNCTION ShowOneGridProc()
DECLARE FUNCTION ShowOneGrid(hDlg AS LONG) AS LONG

'
' PBMAIN - load and show a dialog
'

FUNCTION PBMAIN() AS LONG
     LOCAL result AS LONG
     result=ShowOneGrid(0)
END FUNCTION


'
' Routine to post notifications in a listbox
'


SUB list(s AS STRING)
  LOCAL test AS ASCIIZ * 256
  STATIC COUNT AS LONG
  LOCAL s5 AS STRING * 5

  INCR COUNT
  s5 = STR$(COUNT)
  test="Notification # "+ s5 + ":" + s
  SendMessage(hList1,%LB_INSERTSTRING,0,VARPTR(test))
END SUB


'
' Dialog for 1 Grid  Resizeable
'


FUNCTION ShowOneGrid(hDlg AS LONG) AS LONG

  MLG_Init
  DIALOG NEW 0, "One Grid Example",,, 520, 370, %WS_SYSMENU OR %WS_THICKFRAME TO hDlg

  'Switches
  'e3 means tell MLG to auto append a row if needed providing something is in the cell
  'r50 calls for 50 rows total
  'c8 calls for 8 columns
  'b3 means block selecting of rows, columns, and the entire grid is activated
  'm1 active the right click menu with the following comma delimited menu items

  CONTROL ADD "MYLITTLEGRID", hDlg, %IDC_MLGGRID1, "e3/r50/c8/b3/m1First,Second,Third", 4, 4, 510, 348, %MLG_STYLE
  CONTROL HANDLE hDlg, %IDC_MLGGRID1 TO hGrid1

   CONTROL ADD LISTBOX, hDlg, %IDC_MLGLIST1, , 4, 175, 250, 150,%WS_VSCROLL OR %LBS_NOTIFY ,%WS_EX_CLIENTEDGE
   CONTROL HANDLE hDlg, %IDC_MLGLIST1 TO hList1

   MLG_FormatColCheck hGrid1,1
   MLG_FormatColCombo hGrid1,2,"1st Choice Ed,2nd Choice Ed ,3rd Choice Ed" 'Editable
   MLG_FormatColCombo hGrid1,3,"1st Choice,2nd Choice,3rd Choice",1  'Static
   MLG_FormatColDate hGrid1,4,%MMDDYYYY 'MM/DD/YYYY date format
   MLG_FormatColNumber hGrid1,5,8.2,%MLG_JUST_RIGHT 'max 8 integer digits and max 2 decimal digits
   MLG_FormatColEdit hGrid1,6,5,%MLG_UCASE 'Set max length to 5 characters and upper case everything
   MLG_FormatColEdit hGrid1,7,%MLG_NULL,%MLG_NULL,%MLG_NULL,%RED,%MLG_LOCK
   MLG_FormatColTitles hGrid1,"Check,ComboEdit,ComboStatic,Date MM/DD/YYYY,Number 8.2,Upper Case 5,Locked,Default"
   SendMessage hGrid1, %MLG_SETCOLWIDTH, 4, 130
   MLG_PUT hGrid1,1,7,"LOCKED",0

   DIALOG SHOW MODAL hDlg CALL ShowOneGridProc

END FUNCTION

'
' Dialog procedure for 1 Grid  Resizeable
'
CALLBACK FUNCTION ShowOneGridProc()
  LOCAL I AS LONG
  LOCAL J AS LONG
  LOCAL K AS LONG
  LOCAL myrow AS LONG
  LOCAL oldrow AS LONG
  LOCAL mycol AS LONG
  LOCAL myitem AS LONG
  LOCAL mytype AS LONG
  LOCAL mystart AS LONG
  LOCAL myend AS LONG
  LOCAL mychar AS LONG
  LOCAL mytotalrows AS LONG
  LOCAL mytotalcols AS LONG
  LOCAL s AS STRING
  LOCAL result AS LONG
  LOCAL myget AS STRING
  LOCAL hMenu AS LONG
  LOCAL hEdit AS LONG
  LOCAL MLGN AS MyGridData PTR

  SELECT CASE CBMSG
     CASE %WM_PAINT
        CONTROL REDRAW CBHNDL, %IDC_MLGGRID1

     CASE %WM_SIZE
        DIALOG GET SIZE CBHNDL TO I, J
        CONTROL SET SIZE CBHNDL,%IDC_MLGGRID1, I-14, J-96
        CONTROL SET SIZE CBHNDL,%IDC_MLGLIST1, I-14, 65
        CONTROL SET LOC CBHNDL,%IDC_MLGLIST1, 4, J-86

     CASE %WM_NOTIFY
         MLGN=CBLPARAM
         IF @MLGN.NMHeader.idFrom = %IDC_MLGGRID1 THEN
             SELECT CASE @MLGN.NMHeader.code

                    CASE %MLGN_RETURN
                         myrow=@MLGN.Param1 'current row
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " Return key was pressed. " : list s

                    CASE %MLGN_DELETE
                         myrow=@MLGN.Param1 'current row
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " Delete key was pressed. " : list s

                    CASE %MLGN_TAB
                         myrow=@MLGN.Param1 'current row
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " Tab key was pressed. " : list s

                    CASE %MLGN_CHARPRESSED ' FUNCTION=1 to abort inserting character
                         hEdit=@MLGN.Param4   ' the edit box handle - for inserting char and testing result string
                         mychar=@MLGN.Param3  ' Char
                         mycol=@MLGN.Param2   ' current col
                         myrow=@MLGN.Param1   'current row
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " Character " + CHR$(mychar) + " was pressed." : list s

                    CASE %MLGN_ESCAPEPRESSED
                         myrow=@MLGN.Param1 'current row
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " Escape key was pressed. " : list s

                    CASE %MLGN_ROWDIRTY
                         myrow=@MLGN.Param1        'previous row
                         s=" Row " + STR$(myrow) + " This previous row may need to be saved. " : list s

                    CASE %MLGN_CELLDIRTY
                         myrow=@MLGN.Param1 'previous row
                         mycol=@MLGN.Param2 'previous col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " This previous cell may need to be saved. " : list s

                    CASE %MLGN_ROWALTERED
                         myrow=@MLGN.Param1 'current row
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " row was altered by this cell. " : list s

                    CASE %MLGN_CELLALTERED
                         myrow=@MLGN.Param1 'current row
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " cell was altered. " : list s

                    CASE %MLGN_DATEPROBLEM
                         myrow=@MLGN.Param1 'previous row where the problem occured
                         mycol=@MLGN.Param2 'previous col where the problem occured
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + "; MLG made some alterations to the date. " : list s

                    CASE %MLGN_CHECKCHANGED
                          mychar=@MLGN.Param3  'before toggle - if contained 255 then was unselected else should have contained 1 which was previously selected
                          mycol=@MLGN.Param2   ' Column of check change
                          myrow=@MLGN.Param1          ' Row of check change
                          s="Column " + STR$(mycol) + " Row " + STR$(myrow) + " checkbox toggled from " + STR$(mychar) : list s

                    CASE %MLGN_COMBOCHANGED    'this message is sent on both a dropdown and dismiss of the list
                         myrow=@MLGN.Param1 'current col
                         mycol=@MLGN.Param2 'current col
                         s="Column " + STR$(mycol) + " Row " + STR$(myrow) + "; had combobox activity" : list s

                    CASE %MLGN_COLWIDTHCHANGED
                         I=@MLGN.Param1     ' New Width
                         mycol=@MLGN.Param2 ' Column of Mouse
                         s="Column " + STR$(mycol) + " has Change Width to " + STR$(I) : list s

                    CASE %MLGN_SELCHANGE       'sent after a cell has moved
                         myrow=@MLGN.Param1 'previous row
                         mycol=@MLGN.Param2 'previous col
                         s="Previous Column " + STR$(mycol) + " Previous Row " + STR$(myrow) + " Cell selection has changed. " : list s

                    CASE %MLGN_ROWCHANGE       'sent after a cell has moved
                         myrow=@MLGN.Param1 ' row
                         oldrow=@MLGN.Param2'previous row
                         s="Current Row " + STR$(myrow) + " Previous Row " + STR$(oldrow) + " Row selection has changed. Load Record?" : list s

                    CASE %MLGN_ROWSELCHANGE      'sent after buttonup if whole row/rows selected
                         mystart=@MLGN.Param1 'start row
                         myend=@MLGN.Param2   'end row
                         s="Start Row " + STR$(mystart) + " End Row " + STR$(myend) + " Block selection of rows has changed. " : list s

                    CASE %MLGN_COLSELCHANGE      'sent after buttonup if whole col/cols selected
                         mystart=@MLGN.Param1 'start col
                         myend=@MLGN.Param2   'end col
                         s="Start Column " + STR$(mystart) + " End Column " + STR$(myend) + " Block selection of columns has changed. " : list s

                    CASE %MLGN_ROWCOLALLBLOCKSEL
                         mytotalrows=@MLGN.Param1 'total rows
                         mytotalcols=@MLGN.Param2 'total cols
                         s="Total grid has been block selected.  Total columns= " + STR$(mytotalcols) + " and total rows= " + STR$(mytotalrows) + ". " : list s

                    CASE %MLGN_REDIMFAILED
                        'An automatic append fail
                         I=@MLGN.Param1 'What was the calling point for the problem 1 = PutEX, 2=auto row append, remainder are insert messages
                         J=@MLGN.Param2 'Error codes 1 to 13; Check include file for detail
                         s="A redimensioning of the data memory has failed." : list s

                    CASE %MLGN_WANTNEWREC
                         mytotalrows=@MLGN.Param1   'current total rows before record is append to bottom
                                                 'after a validation can elect to skip append with the %MLG_SETSKIPRECFLAG message
                         s="A row has just been asked to be auto-appended. Total rows are currently " + STR$(mytotalrows) : list s

                    CASE %MLGN_MADENEWREC
                         mytotalrows=@MLGN.Param1    'current total rows after record is append to bottom
                         s="A row has just been auto-appended.  Total rows now are " + STR$(mytotalrows) : list s

                    CASE %MLGN_RIGHTCLICK      'sent after a right click has occur.  Make Menu modifications if necessary
                         myrow=@MLGN.Param1 ' row
                         mycol=@MLGN.Param1 ' col
                         s="Current Column " + STR$(mycol) + " Current Row " + STR$(myrow) + " Right click has occured. " : list s

                    CASE %MLGN_RCLICKMENU
                         myitem=@MLGN.Param3  ' Menu Item
                         mycol=@MLGN.Param2   ' Column of Mouse
                         myrow=@MLGN.Param1          ' Row of Mouse

                         hMenu=SendMessage(hGrid1, %MLG_GETMENUHANDLE, 0, 0)
                         IF myitem=1 AND hMenu > 0 THEN
                           MENU GET STATE hMenu, 1 TO I
                           IF I= %MF_CHECKED THEN
                             MENU SET STATE hMenu, 1, %MF_UNCHECKED
                            ELSE
                             MENU SET STATE hMenu, 1, %MF_CHECKED
                           END IF
                         END IF
           END SELECT
        END IF
  END SELECT

END FUNCTION
